/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.strategies;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.strategies.api.MergeStrategy;
import de.alpharogroup.lang.TypeArgumentsExtensions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import lombok.NonNull;

public class DefaultDaoMergeStrategy<T extends BaseEntity<PK>, PK extends Serializable>
implements MergeStrategy<T, PK> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type = TypeArgumentsExtensions.getFirstTypeArgument(DefaultDaoMergeStrategy.class, this.getClass());
    @NonNull
    private final EntityManagerDao<T, PK> dao;

    public DefaultDaoMergeStrategy(EntityManagerDao<T, PK> dao) {
        this.dao = dao;
    }

    private EntityManager getEntityManager() {
        return this.dao.getEntityManager();
    }

    @Override
    public List<T> merge(List<T> objects) {
        ArrayList<BaseEntity> mergedEntities = new ArrayList<BaseEntity>();
        for (BaseEntity object : objects) {
            mergedEntities.add(this.merge(object));
        }
        return mergedEntities;
    }

    @Override
    public T merge(T entity) {
        return (T)((BaseEntity)this.getEntityManager().merge(entity));
    }

    public Class<T> getType() {
        return this.type;
    }
}

