/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.strategies;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.strategies.api.DeleteStrategy;
import de.alpharogroup.lang.TypeArgumentsExtensions;
import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import lombok.NonNull;

public class DefaultDaoDeleteStrategy<T extends BaseEntity<PK>, PK extends Serializable>
implements DeleteStrategy<T, PK> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type = TypeArgumentsExtensions.getFirstTypeArgument(DefaultDaoDeleteStrategy.class, this.getClass());
    @NonNull
    private final EntityManagerDao<T, PK> dao;

    public DefaultDaoDeleteStrategy(EntityManagerDao<T, PK> dao) {
        this.dao = dao;
    }

    @Override
    public void delete(List<T> objects) {
        for (BaseEntity entity : objects) {
            if (this.getEntityManager().contains((Object)entity)) {
                this.getEntityManager().remove((Object)entity);
                continue;
            }
            this.getEntityManager().remove(this.getEntityManager().merge((Object)entity));
        }
    }

    @Override
    public void delete(PK id) {
        BaseEntity entity = (BaseEntity)this.getEntityManager().find(this.type, id);
        this.delete((T)entity);
    }

    @Override
    public void delete(T entity) {
        if (this.getEntityManager().contains(entity)) {
            this.getEntityManager().remove(entity);
        } else {
            this.getEntityManager().remove(this.getEntityManager().merge(entity));
        }
    }

    private EntityManager getEntityManager() {
        return this.dao.getEntityManager();
    }

    public Class<T> getType() {
        return this.type;
    }
}

