/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.repository;

import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.repository.api.GenericRepository;
import de.alpharogroup.db.strategies.DefaultDeleteStrategy;
import de.alpharogroup.db.strategies.DefaultMergeStrategy;
import de.alpharogroup.db.strategies.DefaultSaveOrUpdateStrategy;
import de.alpharogroup.db.strategies.api.DeleteStrategy;
import de.alpharogroup.db.strategies.api.MergeStrategy;
import de.alpharogroup.db.strategies.api.SaveOrUpdateStrategy;
import de.alpharogroup.lang.TypeArgumentsExtensions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class AbstractRepository<T extends BaseEntity<PK>, PK extends Serializable>
implements GenericRepository<T, PK> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type = TypeArgumentsExtensions.getFirstTypeArgument(AbstractRepository.class, this.getClass());
    @Autowired
    private DataSource dataSource;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private DeleteStrategy<T, PK> deleteStrategy;
    private MergeStrategy<T, PK> mergeStrategy;
    private SaveOrUpdateStrategy<T, PK> saveOrUpdateStrategy;

    public AbstractRepository() {
        this.newDeleteStrategy();
        this.newMergeStrategy();
        this.newSaveOrUpdateStrategy();
    }

    @Override
    public void create(T entity) {
        this.getEntityManager().persist(entity);
    }

    @Override
    public TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return this.getEntityManager().createNamedQuery(name, resultClass);
    }

    @Override
    public TypedQuery<T> createNamedTypedQuery(String name) {
        return this.createNamedQuery(name, this.getType());
    }

    @Override
    public void delete(List<T> entities) {
        if (this.getDeleteStrategy() != null) {
            this.getDeleteStrategy().delete(entities);
        } else {
            for (BaseEntity entity : entities) {
                if (this.getEntityManager().contains((Object)entity)) {
                    this.getEntityManager().remove((Object)entity);
                    continue;
                }
                this.getEntityManager().remove(this.getEntityManager().merge((Object)entity));
            }
        }
    }

    @Override
    public void delete(PK id) {
        if (this.getDeleteStrategy() != null) {
            this.getDeleteStrategy().delete(id);
        } else {
            T entity = this.get(id);
            this.delete(entity);
        }
    }

    @Override
    public void delete(T entity) {
        if (this.getDeleteStrategy() != null) {
            this.getDeleteStrategy().delete(entity);
        } else if (this.getEntityManager().contains(entity)) {
            this.getEntityManager().remove(entity);
        } else {
            this.getEntityManager().remove(this.getEntityManager().merge(entity));
        }
    }

    @Override
    public void evict(T entity) {
        this.getEntityManager().detach(entity);
    }

    @Override
    public boolean exists(PK id) {
        return this.get(id) != null;
    }

    @Override
    public List<T> findAll() {
        CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = builder.createQuery(this.getType());
        Root root = cq.from(this.getType());
        cq.select((Selection)root);
        return this.getEntityManager().createQuery(cq).getResultList();
    }

    @Override
    public T get(PK id) {
        if (id != null) {
            return (T)((BaseEntity)this.getEntityManager().find(this.type, id));
        }
        return null;
    }

    @Override
    public Query getQuery(String hqlQuery) {
        return this.getEntityManager().createQuery(hqlQuery);
    }

    @Override
    public T load(PK id) {
        return this.get(id);
    }

    @Override
    public List<T> merge(List<T> entities) {
        ArrayList<Object> mergedEntities = new ArrayList<Object>();
        if (this.getMergeStrategy() != null) {
            mergedEntities.addAll(this.getMergeStrategy().merge(entities));
        } else {
            for (BaseEntity entity : entities) {
                mergedEntities.add(this.merge(entity));
            }
        }
        return mergedEntities;
    }

    @Override
    public T merge(T entity) {
        if (this.getMergeStrategy() != null) {
            return this.getMergeStrategy().merge(entity);
        }
        return (T)((BaseEntity)this.getEntityManager().merge(entity));
    }

    public DeleteStrategy<T, PK> newDeleteStrategy() {
        this.deleteStrategy = new DefaultDeleteStrategy(this);
        return this.deleteStrategy;
    }

    public MergeStrategy<T, PK> newMergeStrategy() {
        this.mergeStrategy = new DefaultMergeStrategy(this);
        return this.mergeStrategy;
    }

    public SaveOrUpdateStrategy<T, PK> newSaveOrUpdateStrategy() {
        this.saveOrUpdateStrategy = new DefaultSaveOrUpdateStrategy(this);
        return this.saveOrUpdateStrategy;
    }

    @Override
    public void refresh(T entity) {
        this.getEntityManager().refresh(entity);
    }

    @Override
    public List<PK> save(List<T> entities) {
        ArrayList<PK> primaryKeys = new ArrayList<PK>();
        if (this.getSaveOrUpdateStrategy() != null) {
            primaryKeys.addAll((Collection<PK>)this.getSaveOrUpdateStrategy().save(entities));
        } else {
            for (BaseEntity entity : entities) {
                primaryKeys.add(this.save(entity));
            }
        }
        return primaryKeys;
    }

    @Override
    public PK save(T entity) {
        if (this.getSaveOrUpdateStrategy() != null) {
            return this.getSaveOrUpdateStrategy().save(entity);
        }
        this.getEntityManager().persist(entity);
        return ((BaseEntity)entity).getId();
    }

    @Override
    public void saveOrUpdate(List<T> entities) {
        if (this.getSaveOrUpdateStrategy() != null) {
            this.getSaveOrUpdateStrategy().saveOrUpdate(entities);
        } else {
            for (BaseEntity entity : entities) {
                this.saveOrUpdate(entity);
            }
        }
    }

    @Override
    public void saveOrUpdate(T entity) {
        if (this.getSaveOrUpdateStrategy() != null) {
            this.getSaveOrUpdateStrategy().saveOrUpdate(entity);
        } else if (((BaseEntity)entity).getId() == null) {
            this.save(entity);
        } else {
            this.update(entity);
        }
    }

    @Override
    public void update(List<T> entities) {
        if (this.getSaveOrUpdateStrategy() != null) {
            this.getSaveOrUpdateStrategy().update(entities);
        } else {
            for (BaseEntity entity : entities) {
                this.update(entity);
            }
        }
    }

    @Override
    public void update(T entity) {
        if (this.getSaveOrUpdateStrategy() != null) {
            this.getSaveOrUpdateStrategy().update(entity);
        } else {
            this.getEntityManager().merge(entity);
        }
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public DeleteStrategy<T, PK> getDeleteStrategy() {
        return this.deleteStrategy;
    }

    public MergeStrategy<T, PK> getMergeStrategy() {
        return this.mergeStrategy;
    }

    public SaveOrUpdateStrategy<T, PK> getSaveOrUpdateStrategy() {
        return this.saveOrUpdateStrategy;
    }
}

