/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.entity;

import de.alpharogroup.clone.object.CloneObjectExtensions;
import de.alpharogroup.xml.XmlExtensions;
import java.io.Serializable;
import java.util.HashMap;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import org.apache.commons.lang3.builder.ToStringStyle;

@MappedSuperclass
@Access(value=AccessType.FIELD)
public abstract class BaseEntity<PK extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id", nullable=false)
    private PK id;

    public Object clone() throws CloneNotSupportedException {
        return CloneObjectExtensions.cloneObjectQuietly((Object)this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseEntity other = (BaseEntity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    protected ToStringStyle newToStringStyle() {
        return ToStringStyle.SHORT_PREFIX_STYLE;
    }

    public String toXml() {
        HashMap aliases = new HashMap();
        String lqSimpleName = this.getClass().getSimpleName().toLowerCase();
        aliases.put(lqSimpleName, this.getClass());
        String xml = XmlExtensions.toXmlWithXStream((Object)this, aliases);
        return xml;
    }

    public PK getId() {
        return this.id;
    }

    public void setId(PK id) {
        this.id = id;
    }
}

