/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.dao.sessionfactory;

import de.alpharogroup.db.dao.sessionfactory.SessionFactoryDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.lang.TypeArgumentsExtensions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public class GenericHibernateDao<T extends BaseEntity<PK>, PK extends Serializable>
implements SessionFactoryDao<T, PK> {
    private static final long serialVersionUID = 6551795469182243398L;
    private static ThreadLocal<Session> currentSession = new ThreadLocal();
    @Autowired
    private DataSource dataSource;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private SessionFactory sessionFactory;
    private final Class<T> type = TypeArgumentsExtensions.getFirstTypeArgument(GenericHibernateDao.class, this.getClass());

    @Override
    public void delete(List<T> objects) {
        for (BaseEntity object : objects) {
            this.delete((T)object);
        }
    }

    @Override
    public void delete(PK id) {
        this.getSession().delete(this.load(id));
    }

    @Override
    public void delete(PK id, Session session) {
        session.delete(this.load(id));
    }

    @Override
    public void delete(T object) {
        this.getSession().delete(object);
    }

    @Override
    public void delete(T object, Session session) {
        session.delete(object);
    }

    @Override
    public void evict(T object) {
        this.getSession().evict(object);
    }

    @Override
    public boolean exists(PK id) {
        if (id != null) {
            return null != this.get(id);
        }
        return false;
    }

    @Override
    public List<T> find(String hqlQuery, String[] params, Object[] paramValues, Type[] paramTypes, Integer start, Integer count) {
        int paramsLength;
        Query query = this.getQuery(hqlQuery);
        int n = paramsLength = params == null ? 0 : params.length;
        if (params != null) {
            if (paramValues == null || paramValues.length != params.length) {
                throw new IllegalArgumentException("ParamValues not completely specified for all params");
            }
            if (paramValues == null || paramTypes.length != params.length) {
                throw new IllegalArgumentException("ParamTypes not completely specified for all params");
            }
        }
        for (int i = 0; i < paramsLength; ++i) {
            query.setParameter(params[i], paramValues[i], paramTypes[i]);
        }
        if (start == null) {
            query.setFirstResult(0);
        } else {
            query.setFirstResult(start.intValue());
        }
        if (count == null) {
            query.setMaxResults(0);
        } else {
            query.setMaxResults(count.intValue());
        }
        return query.list();
    }

    @Override
    public List<T> findAll() {
        return this.findByCriteria(new Criterion[0]);
    }

    @Override
    public List<T> findByCriteria(Criterion ... criterion) {
        Criteria crit = this.getSession().createCriteria(this.getPersistentClass());
        for (Criterion c : criterion) {
            crit.add(c);
        }
        return crit.list();
    }

    @Override
    public List<T> findByExample(T exampleInstance, String ... excludeProperty) {
        Criteria crit = this.getSession().createCriteria(this.getPersistentClass());
        Example example = Example.create(exampleInstance);
        for (String exclude : excludeProperty) {
            example.excludeProperty(exclude);
        }
        crit.add((Criterion)example);
        return crit.list();
    }

    @Override
    public T get(PK id) {
        return (T)((BaseEntity)this.getSession().get(this.type, id));
    }

    @Override
    public T get(PK id, Session session) {
        return (T)((BaseEntity)session.get(this.type, id));
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public Class<T> getPersistentClass() {
        return this.type;
    }

    @Override
    public Query getQuery(String hqlQuery) {
        return this.getSession().createQuery(hqlQuery);
    }

    @Override
    public Query getQuery(String queryString, Session session) {
        return session.createQuery(queryString);
    }

    @Override
    public Session getSession() {
        Session session = null;
        try {
            session = this.sessionFactory.getCurrentSession();
        }
        catch (HibernateException e) {
            if (currentSession.get() == null) {
                session = this.sessionFactory.openSession();
                session.setFlushMode(FlushMode.ALWAYS);
                this.setSession(session);
            }
            session = currentSession.get();
        }
        return session;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public T load(PK id) {
        return (T)((BaseEntity)this.getSession().load(this.type, id));
    }

    @Override
    public T load(PK id, Session session) {
        return (T)((BaseEntity)session.load(this.type, id));
    }

    @Override
    public List<T> merge(List<T> objects) {
        ArrayList<BaseEntity> mergedEntities = new ArrayList<BaseEntity>();
        for (BaseEntity object : objects) {
            mergedEntities.add(this.merge(object));
        }
        return mergedEntities;
    }

    @Override
    public T merge(T object) {
        return (T)((BaseEntity)this.getSession().merge(object));
    }

    @Override
    public void refresh(T object) {
        this.getSession().refresh(object);
    }

    @Override
    public List<PK> save(List<T> objects) {
        ArrayList<PK> primaryKeys = new ArrayList<PK>();
        for (BaseEntity object : objects) {
            primaryKeys.add(this.save(object));
        }
        return primaryKeys;
    }

    @Override
    public PK save(T object) {
        return (PK)this.getSession().save(object);
    }

    @Override
    public PK save(T object, Session session) {
        return (PK)session.save(object);
    }

    @Override
    public void saveOrUpdate(List<T> objects) {
        for (BaseEntity object : objects) {
            this.saveOrUpdate(object);
        }
    }

    @Override
    public void saveOrUpdate(T object) {
        this.getSession().saveOrUpdate(object);
    }

    @Override
    public void saveOrUpdate(T object, Session session) {
        session.saveOrUpdate(object);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public void setSession(Session session) {
        currentSession.set(session);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void update(List<T> objects) {
        for (BaseEntity object : objects) {
            this.saveOrUpdate(object);
        }
    }

    @Override
    public void update(T object) {
        this.getSession().update(object);
    }

    @Override
    public void update(T object, Session session) {
        session.update(object);
    }
}

