/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.dao.jpa;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.strategies.DeleteStrategy;
import de.alpharogroup.db.strategies.MergeStrategy;
import de.alpharogroup.db.strategies.SaveOrUpdateStrategy;
import de.alpharogroup.lang.TypeArgumentsExtensions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class JpaEntityManagerDao<T extends BaseEntity<PK>, PK extends Serializable>
implements EntityManagerDao<T, PK> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type = TypeArgumentsExtensions.getFirstTypeArgument(JpaEntityManagerDao.class, this.getClass());
    @Autowired
    private DataSource dataSource;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private DeleteStrategy<T, PK> deleteStrategy;
    private MergeStrategy<T, PK> mergeStrategy;
    private SaveOrUpdateStrategy<T, PK> saveOrUpdateStrategy;

    public JpaEntityManagerDao() {
        this.newDeleteStrategy();
        this.newMergeStrategy();
        this.newSaveOrUpdateStrategy();
    }

    @Override
    public void create(T entity) {
        this.getEntityManager().persist(entity);
    }

    @Override
    public void delete(List<T> objects) {
        if (this.getDeleteStrategy() == null) {
            for (BaseEntity entity : objects) {
                this.getEntityManager().remove((Object)entity);
            }
        } else {
            this.getDeleteStrategy().delete(objects);
        }
    }

    @Override
    public void delete(PK id) {
        if (this.getDeleteStrategy() == null) {
            T entity = this.get(id);
            this.delete(entity);
        } else {
            this.getDeleteStrategy().delete(id);
        }
    }

    @Override
    public void delete(T entity) {
        if (this.getDeleteStrategy() == null) {
            this.getEntityManager().remove(entity);
        } else {
            this.getDeleteStrategy().delete(entity);
        }
    }

    @Override
    public void evict(T object) {
        this.getEntityManager().detach(object);
    }

    @Override
    public boolean exists(PK id) {
        return this.get(id) != null;
    }

    @Override
    public List<T> findAll() {
        CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = builder.createQuery(this.getType());
        Root root = cq.from(this.getType());
        cq.select((Selection)root);
        return this.getEntityManager().createQuery(cq).getResultList();
    }

    @Override
    public T get(PK id) {
        if (id != null) {
            return (T)((BaseEntity)this.getEntityManager().find(this.type, id));
        }
        return null;
    }

    @Override
    public Query getQuery(String hqlQuery) {
        return this.getEntityManager().createQuery(hqlQuery);
    }

    @Override
    public T load(PK id) {
        return this.get(id);
    }

    @Override
    public List<T> merge(List<T> objects) {
        ArrayList<BaseEntity<Object>> mergedEntities = new ArrayList<BaseEntity<Object>>();
        if (this.getMergeStrategy() == null) {
            for (BaseEntity object : objects) {
                mergedEntities.add(this.merge(object));
            }
        } else {
            mergedEntities.addAll(this.getMergeStrategy().merge(objects));
        }
        return mergedEntities;
    }

    @Override
    public T merge(T object) {
        if (this.getMergeStrategy() == null) {
            return (T)((BaseEntity)this.getEntityManager().merge(object));
        }
        return this.getMergeStrategy().merge(object);
    }

    public DeleteStrategy<T, PK> newDeleteStrategy() {
        this.deleteStrategy = null;
        return this.deleteStrategy;
    }

    public MergeStrategy<T, PK> newMergeStrategy() {
        this.mergeStrategy = null;
        return this.mergeStrategy;
    }

    public SaveOrUpdateStrategy<T, PK> newSaveOrUpdateStrategy() {
        this.saveOrUpdateStrategy = null;
        return this.saveOrUpdateStrategy;
    }

    @Override
    public void refresh(T object) {
        this.getEntityManager().refresh(object);
    }

    @Override
    public List<PK> save(List<T> objects) {
        ArrayList<PK> primaryKeys = new ArrayList<PK>();
        if (this.getSaveOrUpdateStrategy() == null) {
            for (BaseEntity object : objects) {
                primaryKeys.add(this.save(object));
            }
        } else {
            primaryKeys.addAll((Collection<PK>)this.getSaveOrUpdateStrategy().save(objects));
        }
        return primaryKeys;
    }

    @Override
    public PK save(T object) {
        if (this.getSaveOrUpdateStrategy() == null) {
            this.getEntityManager().persist(object);
            return ((BaseEntity)object).getId();
        }
        return this.getSaveOrUpdateStrategy().save(object);
    }

    @Override
    public void saveOrUpdate(List<T> objects) {
        this.save((T)objects);
    }

    @Override
    public void saveOrUpdate(T object) {
        this.save(object);
    }

    @Override
    public void update(List<T> objects) {
        if (this.getSaveOrUpdateStrategy() == null) {
            for (BaseEntity t : objects) {
                this.update(t);
            }
        } else {
            this.getSaveOrUpdateStrategy().update(objects);
        }
    }

    @Override
    public void update(T entity) {
        if (this.getSaveOrUpdateStrategy() == null) {
            this.getEntityManager().merge(entity);
        } else {
            this.getSaveOrUpdateStrategy().update(entity);
        }
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public DeleteStrategy<T, PK> getDeleteStrategy() {
        return this.deleteStrategy;
    }

    public MergeStrategy<T, PK> getMergeStrategy() {
        return this.mergeStrategy;
    }

    public SaveOrUpdateStrategy<T, PK> getSaveOrUpdateStrategy() {
        return this.saveOrUpdateStrategy;
    }
}

