/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.converter;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter(autoApply=true)
public class ZonedDateTimeConverter
implements AttributeConverter<ZonedDateTime, Date> {
    public Date convertToDatabaseColumn(ZonedDateTime date) {
        Instant instant = Instant.from(date);
        return Date.from(instant);
    }

    public ZonedDateTime convertToEntityAttribute(Date value) {
        Instant instant = value.toInstant();
        return ZonedDateTime.from(instant);
    }
}

