/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.model;

import de.alpharogroup.crypto.algorithm.Algorithm;
import java.io.Serializable;
import java.util.Arrays;

public class CryptModel<C, K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Algorithm algorithm;
    private C cipher;
    private boolean initialized;
    private Integer iterationCount;
    private K key;
    private int operationMode;
    private byte[] salt;

    public static <C, K> CryptModelBuilder<C, K> builder() {
        return new CryptModelBuilder();
    }

    public CryptModelBuilder<C, K> toBuilder() {
        return new CryptModelBuilder().algorithm(this.algorithm).cipher(this.cipher).initialized(this.initialized).iterationCount(this.iterationCount).key(this.key).operationMode(this.operationMode).salt(this.salt);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public C getCipher() {
        return this.cipher;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Integer getIterationCount() {
        return this.iterationCount;
    }

    public K getKey() {
        return this.key;
    }

    public int getOperationMode() {
        return this.operationMode;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public void setCipher(C cipher) {
        this.cipher = cipher;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void setIterationCount(Integer iterationCount) {
        this.iterationCount = iterationCount;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public void setOperationMode(int operationMode) {
        this.operationMode = operationMode;
    }

    public void setSalt(byte[] salt) {
        this.salt = salt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CryptModel)) {
            return false;
        }
        CryptModel other = (CryptModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Algorithm this$algorithm = this.getAlgorithm();
        Algorithm other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        C this$cipher = this.getCipher();
        C other$cipher = other.getCipher();
        if (this$cipher == null ? other$cipher != null : !this$cipher.equals(other$cipher)) {
            return false;
        }
        if (this.isInitialized() != other.isInitialized()) {
            return false;
        }
        Integer this$iterationCount = this.getIterationCount();
        Integer other$iterationCount = other.getIterationCount();
        if (this$iterationCount == null ? other$iterationCount != null : !((Object)this$iterationCount).equals(other$iterationCount)) {
            return false;
        }
        K this$key = this.getKey();
        K other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        if (this.getOperationMode() != other.getOperationMode()) {
            return false;
        }
        return Arrays.equals(this.getSalt(), other.getSalt());
    }

    protected boolean canEqual(Object other) {
        return other instanceof CryptModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Algorithm $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        C $cipher = this.getCipher();
        result = result * 59 + ($cipher == null ? 43 : $cipher.hashCode());
        result = result * 59 + (this.isInitialized() ? 79 : 97);
        Integer $iterationCount = this.getIterationCount();
        result = result * 59 + ($iterationCount == null ? 43 : ((Object)$iterationCount).hashCode());
        K $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        result = result * 59 + this.getOperationMode();
        result = result * 59 + Arrays.hashCode(this.getSalt());
        return result;
    }

    public String toString() {
        return "CryptModel(algorithm=" + this.getAlgorithm() + ", cipher=" + this.getCipher() + ", initialized=" + this.isInitialized() + ", iterationCount=" + this.getIterationCount() + ", key=" + this.getKey() + ", operationMode=" + this.getOperationMode() + ", salt=" + Arrays.toString(this.getSalt()) + ")";
    }

    public CryptModel() {
    }

    public CryptModel(Algorithm algorithm, C cipher, boolean initialized, Integer iterationCount, K key, int operationMode, byte[] salt) {
        this.algorithm = algorithm;
        this.cipher = cipher;
        this.initialized = initialized;
        this.iterationCount = iterationCount;
        this.key = key;
        this.operationMode = operationMode;
        this.salt = salt;
    }

    public static class CryptModelBuilder<C, K> {
        private Algorithm algorithm;
        private C cipher;
        private boolean initialized;
        private Integer iterationCount;
        private K key;
        private int operationMode;
        private byte[] salt;

        CryptModelBuilder() {
        }

        public CryptModelBuilder<C, K> algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public CryptModelBuilder<C, K> cipher(C cipher) {
            this.cipher = cipher;
            return this;
        }

        public CryptModelBuilder<C, K> initialized(boolean initialized) {
            this.initialized = initialized;
            return this;
        }

        public CryptModelBuilder<C, K> iterationCount(Integer iterationCount) {
            this.iterationCount = iterationCount;
            return this;
        }

        public CryptModelBuilder<C, K> key(K key) {
            this.key = key;
            return this;
        }

        public CryptModelBuilder<C, K> operationMode(int operationMode) {
            this.operationMode = operationMode;
            return this;
        }

        public CryptModelBuilder<C, K> salt(byte[] salt) {
            this.salt = salt;
            return this;
        }

        public CryptModel<C, K> build() {
            return new CryptModel<C, K>(this.algorithm, this.cipher, this.initialized, this.iterationCount, this.key, this.operationMode, this.salt);
        }

        public String toString() {
            return "CryptModel.CryptModelBuilder(algorithm=" + this.algorithm + ", cipher=" + this.cipher + ", initialized=" + this.initialized + ", iterationCount=" + this.iterationCount + ", key=" + this.key + ", operationMode=" + this.operationMode + ", salt=" + Arrays.toString(this.salt) + ")";
        }
    }
}

