/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key.reader;

import de.alpharogroup.crypto.algorithm.KeyPairGeneratorAlgorithm;
import de.alpharogroup.crypto.factories.CipherFactory;
import de.alpharogroup.crypto.factories.KeySpecFactory;
import de.alpharogroup.crypto.factories.SecretKeyFactoryExtensions;
import de.alpharogroup.crypto.key.reader.PrivateKeyReader;
import de.alpharogroup.crypto.provider.SecurityProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public final class EncryptedPrivateKeyReader {
    public static PrivateKey readPasswordProtectedPrivateKey(byte[] encryptedPrivateKeyBytes, String password, String algorithm) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(encryptedPrivateKeyBytes);
        String algName = encryptedPrivateKeyInfo.getAlgName();
        Cipher cipher = CipherFactory.newCipher(algName);
        KeySpec pbeKeySpec = KeySpecFactory.newPBEKeySpec(password);
        SecretKeyFactory secretKeyFactory = SecretKeyFactoryExtensions.newSecretKeyFactory(algName);
        SecretKey pbeKey = secretKeyFactory.generateSecret(pbeKeySpec);
        AlgorithmParameters algParameters = encryptedPrivateKeyInfo.getAlgParameters();
        cipher.init(2, (Key)pbeKey, algParameters);
        PKCS8EncodedKeySpec pkcs8KeySpec = encryptedPrivateKeyInfo.getKeySpec(cipher);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePrivate(pkcs8KeySpec);
    }

    public static PrivateKey readPasswordProtectedPrivateKey(File encryptedPrivateKeyFile, String password, String algorithm) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] encryptedPrivateKeyBytes = null;
        boolean pemFormat = PrivateKeyReader.isPemFormat(encryptedPrivateKeyFile);
        if (pemFormat) {
            KeyPair keyPair = EncryptedPrivateKeyReader.getKeyPair(encryptedPrivateKeyFile, password);
            if (keyPair != null) {
                return keyPair.getPrivate();
            }
        } else {
            encryptedPrivateKeyBytes = Files.readAllBytes(encryptedPrivateKeyFile.toPath());
            return EncryptedPrivateKeyReader.readPasswordProtectedPrivateKey(encryptedPrivateKeyBytes, password, algorithm);
        }
        return null;
    }

    public static KeyPair getKeyPair(File encryptedPrivateKeyFile, String password) throws FileNotFoundException, IOException, PEMException {
        KeyPair keyPair;
        PEMParser pemParser = new PEMParser((Reader)new FileReader(encryptedPrivateKeyFile));
        Object pemObject = pemParser.readObject();
        pemParser.close();
        JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter().setProvider(SecurityProvider.BC.name());
        if (pemObject instanceof PEMEncryptedKeyPair) {
            PEMDecryptorProvider decryptorProvider = new JcePEMDecryptorProviderBuilder().setProvider(SecurityProvider.BC.name()).build(password.toCharArray());
            keyPair = keyConverter.getKeyPair(((PEMEncryptedKeyPair)pemObject).decryptKeyPair(decryptorProvider));
        } else {
            keyPair = keyConverter.getKeyPair((PEMKeyPair)pemObject);
        }
        return keyPair;
    }

    public static PrivateKey readPasswordProtectedPrivateKey(File encryptedPrivateKeyFile, String password) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        return EncryptedPrivateKeyReader.readPasswordProtectedPrivateKey(encryptedPrivateKeyFile, password, KeyPairGeneratorAlgorithm.RSA.getAlgorithm());
    }

    private EncryptedPrivateKeyReader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

