/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.hex;

import java.nio.charset.Charset;
import lombok.NonNull;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public final class HexExtensions {
    private static final char[] HEXADECIMAL_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String decodeHex(byte[] data) {
        return new String(data);
    }

    public static byte[] decodeHex(char[] data) throws DecoderException {
        return Hex.decodeHex((char[])data);
    }

    public static String decodeHex(String hexString) throws DecoderException {
        byte[] decodedBytes = HexExtensions.decodeHex(hexString.toCharArray());
        String decodedString = HexExtensions.decodeHex(decodedBytes);
        return decodedString;
    }

    public static String decodeHexToString(char[] data) throws DecoderException {
        return new String(Hex.decodeHex((char[])data));
    }

    public static char[] encodeHex(byte[] data) {
        return HexExtensions.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean lowerCase) {
        return Hex.encodeHex((byte[])data, (boolean)lowerCase);
    }

    public static char[] encodeHex(String data) {
        return HexExtensions.encodeHex(data.getBytes());
    }

    public static String encodeHex(@NonNull String string, Charset charset, boolean lowerCase) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        char[] encodedCharArray = charset != null ? HexExtensions.encodeHex(string.getBytes(charset), lowerCase) : HexExtensions.encodeHex(string.getBytes(), lowerCase);
        String encodedString = new String(encodedCharArray);
        return encodedString;
    }

    public static char toHex(int i) {
        return HEXADECIMAL_DIGITS[i & 0xF];
    }

    public static String toHexString(byte[] data) {
        return HexExtensions.toHexString(data, true);
    }

    public static String toHexString(byte[] data, boolean lowerCase) {
        StringBuilder sb = new StringBuilder();
        sb.append(HexExtensions.encodeHex(data, lowerCase));
        return sb.toString();
    }

    private HexExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

