/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.factories;

import de.alpharogroup.crypto.provider.SecurityProvider;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public final class CertFactory {
    public static X509Certificate newX509Certificate(String type, byte[] certificateData) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance(type);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(certificateData);
        X509Certificate certificate = (X509Certificate)cf.generateCertificate(inputStream);
        return certificate;
    }

    public static X509Certificate newX509Certificate(PublicKey publicKey, PrivateKey privateKey, BigInteger serialNumber, String subject, String issuer, String signatureAlgorithm, Date start, Date end) throws CertificateEncodingException, InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, SignatureException {
        X500Principal subjectPrincipal = new X500Principal(subject);
        X500Principal issuerPrincipal = new X500Principal(issuer);
        X509V3CertificateGenerator certificateGenerator = new X509V3CertificateGenerator();
        certificateGenerator.setPublicKey(publicKey);
        certificateGenerator.setSerialNumber(serialNumber);
        certificateGenerator.setSubjectDN(subjectPrincipal);
        certificateGenerator.setIssuerDN(issuerPrincipal);
        certificateGenerator.setNotBefore(start);
        certificateGenerator.setNotAfter(end);
        certificateGenerator.setSignatureAlgorithm(signatureAlgorithm);
        X509Certificate certificate = certificateGenerator.generate(privateKey);
        return certificate;
    }

    public static X509Certificate newX509CertificateV1(KeyPair keyPair, X500Name issuer, BigInteger serial, Date notBefore, Date notAfter, X500Name subject, String signatureAlgorithm) throws OperatorCreationException, CertificateException {
        JcaX509v1CertificateBuilder certBuilder = new JcaX509v1CertificateBuilder(issuer, serial, notBefore, notAfter, subject, keyPair.getPublic());
        ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).setProvider(SecurityProvider.BC.name()).build(keyPair.getPrivate());
        X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider(SecurityProvider.BC.name()).getCertificate(certBuilder.build(signer));
        return x509Certificate;
    }

    public static X509Certificate newIntermediateX509CertificateV3(KeyPair keyPair, X500Name issuer, BigInteger serial, Date notBefore, Date notAfter, X500Name subject, String signatureAlgorithm, X509Certificate caCert) throws NoSuchAlgorithmException, CertIOException, OperatorCreationException, CertificateException {
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(issuer, serial, notBefore, notAfter, subject, keyPair.getPublic());
        JcaX509ExtensionUtils extensionUtils = new JcaX509ExtensionUtils();
        certBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extensionUtils.createAuthorityKeyIdentifier(caCert));
        certBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extensionUtils.createSubjectKeyIdentifier(keyPair.getPublic()));
        certBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0));
        certBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(134));
        ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).setProvider(SecurityProvider.BC.name()).build(keyPair.getPrivate());
        return new JcaX509CertificateConverter().setProvider(SecurityProvider.BC.name()).getCertificate(certBuilder.build(signer));
    }

    public static X509Certificate newEndEntityX509CertificateV3(KeyPair keyPair, X500Name issuer, BigInteger serial, Date notBefore, Date notAfter, X500Name subject, String signatureAlgorithm, X509Certificate caCert) throws NoSuchAlgorithmException, CertIOException, OperatorCreationException, CertificateException {
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(issuer, serial, notBefore, notAfter, subject, keyPair.getPublic());
        JcaX509ExtensionUtils extensionUtils = new JcaX509ExtensionUtils();
        certBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extensionUtils.createAuthorityKeyIdentifier(caCert));
        certBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extensionUtils.createSubjectKeyIdentifier(keyPair.getPublic()));
        certBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        certBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(160));
        ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).setProvider(SecurityProvider.BC.name()).build(keyPair.getPrivate());
        return new JcaX509CertificateConverter().setProvider(SecurityProvider.BC.name()).getCertificate(certBuilder.build(signer));
    }

    private CertFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

