/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key.reader;

import de.alpharogroup.crypto.provider.SecurityProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;

public final class PemObjectReader {
    public static PemObject getPemObject(File file) throws IOException {
        PemObject pemObject;
        try (PemReader pemReader = new PemReader((Reader)new InputStreamReader(new FileInputStream(file)));){
            pemObject = pemReader.readPemObject();
        }
        return pemObject;
    }

    public static PrivateKey readPemPrivateKey(File keyFile, String password) throws IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try (PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(new FileInputStream(keyFile)));){
            PEMEncryptedKeyPair encryptedKeyPair = (PEMEncryptedKeyPair)pemParser.readObject();
            PEMDecryptorProvider decryptorProvider = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
            PEMKeyPair pemKeyPair = encryptedKeyPair.decryptKeyPair(decryptorProvider);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(SecurityProvider.BC.name());
            PrivateKey privateKey = converter.getPrivateKey(pemKeyPair.getPrivateKeyInfo());
            return privateKey;
        }
    }

    public static String toPemFormat(PemObject pemObject) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)stringWriter);
        pemWriter.writeObject((PemObjectGenerator)pemObject);
        pemWriter.close();
        String pemString = stringWriter.toString();
        return pemString;
    }

    private PemObjectReader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

