/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key;

import de.alpharogroup.crypto.algorithm.KeyPairGeneratorAlgorithm;
import de.alpharogroup.crypto.hex.HexExtensions;
import de.alpharogroup.crypto.key.KeySize;
import de.alpharogroup.crypto.key.reader.PemObjectReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public final class PrivateKeyExtensions {
    public static int getKeyLength(PrivateKey privateKey) {
        int length = -1;
        if (privateKey == null) {
            return length;
        }
        if (privateKey instanceof RSAPrivateKey) {
            length = ((RSAPrivateKey)privateKey).getModulus().bitLength();
        }
        if (privateKey instanceof DSAPrivateKey) {
            length = ((DSAPrivateKey)privateKey).getParams().getQ().bitLength();
        }
        if (privateKey instanceof ECPrivateKey) {
            length = ((ECPrivateKey)privateKey).getParams().getCurve().getField().getFieldSize();
        }
        return length;
    }

    public static KeySize getKeySize(PrivateKey privateKey) {
        int length = PrivateKeyExtensions.getKeyLength(privateKey);
        if (length == 1024) {
            return KeySize.KEYSIZE_1024;
        }
        if (length == 2048) {
            return KeySize.KEYSIZE_2048;
        }
        if (length == 4096) {
            return KeySize.KEYSIZE_4096;
        }
        if (length == 8192) {
            return KeySize.KEYSIZE_8192;
        }
        return null;
    }

    public static String toHexString(PrivateKey privateKey) {
        return PrivateKeyExtensions.toHexString(privateKey, true);
    }

    public static String toHexString(PrivateKey privateKey, boolean lowerCase) {
        return HexExtensions.toHexString(privateKey.getEncoded(), lowerCase);
    }

    public static String toBase64(PrivateKey privateKey) {
        byte[] encoded = privateKey.getEncoded();
        String privateKeyAsBase64String = Base64.encodeBase64String((byte[])encoded);
        return privateKeyAsBase64String;
    }

    public static String toBase64Binary(PrivateKey privateKey) {
        byte[] encoded = privateKey.getEncoded();
        String privateKeyAsBase64String = DatatypeConverter.printBase64Binary((byte[])encoded);
        return privateKeyAsBase64String;
    }

    public static PublicKey generatePublicKey(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (privateKey instanceof RSAPrivateKey) {
            RSAPrivateCrtKey privk = (RSAPrivateCrtKey)privateKey;
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(privk.getModulus(), privk.getPublicExponent());
            KeyFactory keyFactory = KeyFactory.getInstance(KeyPairGeneratorAlgorithm.RSA.getAlgorithm());
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            return publicKey;
        }
        return null;
    }

    public static String toPemFormat(PrivateKey privateKey) throws IOException {
        return PemObjectReader.toPemFormat(new PemObject("RSA PRIVATE KEY", PrivateKeyExtensions.toPKCS1Format(privateKey)));
    }

    public static byte[] toPKCS1Format(PrivateKey privateKey) throws IOException {
        byte[] encoded = privateKey.getEncoded();
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)encoded);
        ASN1Encodable asn1Encodable = privateKeyInfo.parsePrivateKey();
        ASN1Primitive asn1Primitive = asn1Encodable.toASN1Primitive();
        byte[] privateKeyPKCS1Formatted = asn1Primitive.getEncoded();
        return privateKeyPKCS1Formatted;
    }

    public static String fromPKCS1ToPemFormat(byte[] privateKeyPKCS1Formatted) throws IOException {
        PemObject pemObject = new PemObject("RSA PRIVATE KEY", privateKeyPKCS1Formatted);
        StringWriter stringWriter = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)stringWriter);
        pemWriter.writeObject((PemObjectGenerator)pemObject);
        pemWriter.close();
        String string = stringWriter.toString();
        return string;
    }

    private PrivateKeyExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

