/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key;

import de.alpharogroup.crypto.algorithm.HashAlgorithm;
import de.alpharogroup.crypto.hex.HexExtensions;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

public final class CertificateExtensions {
    public static String getIssuedTo(X509Certificate certificate) {
        X500Principal issuedToPrincipal = certificate.getIssuerX500Principal();
        String issuedTo = issuedToPrincipal.getName();
        return issuedTo;
    }

    public static String getIssuedBy(X509Certificate certificate) {
        X500Principal issuedByPrincipal = certificate.getSubjectX500Principal();
        String issuedBy = issuedByPrincipal.getName();
        return issuedBy;
    }

    public static String getOrganization(X509Certificate certificate) throws CertificateEncodingException {
        return CertificateExtensions.getFirstValueOf(certificate, BCStyle.O);
    }

    public static String getLocality(X509Certificate certificate) throws CertificateEncodingException {
        return CertificateExtensions.getFirstValueOf(certificate, BCStyle.L);
    }

    public static String getCountry(X509Certificate certificate) throws CertificateEncodingException {
        return CertificateExtensions.getFirstValueOf(certificate, BCStyle.C);
    }

    public static String getFirstValueOf(X509Certificate certificate, ASN1ObjectIdentifier style) throws CertificateEncodingException {
        X500Name x500name = new JcaX509CertificateHolder(certificate).getSubject();
        RDN[] rdns = x500name.getRDNs(style);
        if (rdns != null && 0 < rdns.length) {
            RDN rdn = rdns[0];
            String firstValue = IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue());
            return firstValue;
        }
        return "";
    }

    public static Date getValidFrom(X509Certificate certificate) {
        return certificate.getNotBefore();
    }

    public static Date getValidUntil(X509Certificate certificate) {
        return certificate.getNotAfter();
    }

    public static String getFingerprint(X509Certificate certificate, HashAlgorithm hashAlgorithm) throws CertificateEncodingException, NoSuchAlgorithmException {
        byte[] derEncoded = certificate.getEncoded();
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm.getAlgorithm());
        messageDigest.update(derEncoded);
        byte[] digest = messageDigest.digest();
        String fingerprint = HexExtensions.toHexString(digest);
        return fingerprint;
    }

    public static String getSignatureAlgorithm(X509Certificate certificate) {
        return certificate.getSigAlgName();
    }

    private CertificateExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

