/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.factories;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public final class KeyStoreFactory {
    public static KeyStore newKeyStore(String type, String password, File keystoreFile) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException {
        return KeyStoreFactory.newKeyStore(type, password, keystoreFile, false);
    }

    public static KeyStore newKeyStore(String type, String password, File keystoreFile, boolean newEmpty) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance(type);
        if (newEmpty) {
            keyStore.load(null, password.toCharArray());
            if (!keystoreFile.exists()) {
                keystoreFile.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(keystoreFile);
            keyStore.store(out, password.toCharArray());
            return keyStore;
        }
        keyStore.load(new FileInputStream(keystoreFile), password.toCharArray());
        return keyStore;
    }

    private KeyStoreFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

