/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key.reader;

import de.alpharogroup.crypto.algorithm.KeyPairGeneratorAlgorithm;
import de.alpharogroup.crypto.factories.CipherFactory;
import de.alpharogroup.crypto.factories.KeySpecFactory;
import de.alpharogroup.crypto.factories.SecretKeyFactoryExtensions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

public final class EncryptedPrivateKeyReader {
    public static PrivateKey decryptPasswordProtectedPrivateKey(byte[] encryptedPrivateKeyBytes, String password, String algorithm) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(encryptedPrivateKeyBytes);
        String algName = encryptedPrivateKeyInfo.getAlgName();
        Cipher cipher = CipherFactory.newCipher(algName);
        KeySpec pbeKeySpec = KeySpecFactory.newPBEKeySpec(password);
        SecretKeyFactory secretKeyFactory = SecretKeyFactoryExtensions.newSecretKeyFactory(algName);
        SecretKey pbeKey = secretKeyFactory.generateSecret(pbeKeySpec);
        AlgorithmParameters algParameters = encryptedPrivateKeyInfo.getAlgParameters();
        cipher.init(2, (Key)pbeKey, algParameters);
        PKCS8EncodedKeySpec pkcs8KeySpec = encryptedPrivateKeyInfo.getKeySpec(cipher);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePrivate(pkcs8KeySpec);
    }

    public static PrivateKey decryptPasswordProtectedPrivateKey(File encryptedPrivateKeyFile, String password, String algorithm) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] encryptedPrivateKeyBytes = Files.readAllBytes(encryptedPrivateKeyFile.toPath());
        return EncryptedPrivateKeyReader.decryptPasswordProtectedPrivateKey(encryptedPrivateKeyBytes, password, algorithm);
    }

    public static PrivateKey decryptPasswordProtectedPrivateKey(File encryptedPrivateKeyFile, String password) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        return EncryptedPrivateKeyReader.decryptPasswordProtectedPrivateKey(encryptedPrivateKeyFile, password, KeyPairGeneratorAlgorithm.RSA.getAlgorithm());
    }

    private EncryptedPrivateKeyReader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

