/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.factories;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class SecretKeyFactoryExtensions {
    public static SecretKeyFactory newSecretKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm);
        return factory;
    }

    public static SecretKeySpec newSecretKeySpec(String algorithm, int keyLength) throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
        keyGenerator.init(keyLength);
        SecretKey secretKey = keyGenerator.generateKey();
        byte[] secretKeyEncoded = secretKey.getEncoded();
        return SecretKeyFactoryExtensions.newSecretKeySpec(secretKeyEncoded, algorithm);
    }

    public static SecretKeySpec newSecretKeySpec(byte[] secretKey, String algorithm) throws NoSuchAlgorithmException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey, algorithm);
        return secretKeySpec;
    }

    public static SecretKey newSecretKey(char[] password, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algorithm);
        SecretKey secretKey = secretKeyFactory.generateSecret(pbeKeySpec);
        return secretKey;
    }

    private SecretKeyFactoryExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

