/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.factories;

import de.alpharogroup.crypto.factories.AlgorithmParameterSpecFactory;
import de.alpharogroup.crypto.factories.KeySpecFactory;
import de.alpharogroup.crypto.factories.SecretKeyFactoryExtensions;
import de.alpharogroup.crypto.model.CryptModel;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

public final class CipherFactory {
    public static Cipher newCipher(int operationMode, SecretKey key, AlgorithmParameterSpec paramSpec, String algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = CipherFactory.newCipher(algorithm);
        cipher.init(operationMode, (Key)key, paramSpec);
        return cipher;
    }

    public static Cipher newCipher(String algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance(algorithm);
        return cipher;
    }

    public static Cipher newCipher(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance(algorithm, provider);
        return cipher;
    }

    public static Cipher newCipher(String privateKey, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        KeySpec keySpec = KeySpecFactory.newPBEKeySpec(privateKey, salt, iterationCount);
        SecretKeyFactory factory = SecretKeyFactoryExtensions.newSecretKeyFactory(algorithm);
        SecretKey key = factory.generateSecret(keySpec);
        AlgorithmParameterSpec paramSpec = AlgorithmParameterSpecFactory.newPBEParameterSpec(salt, iterationCount);
        return CipherFactory.newCipher(operationMode, key, paramSpec, key.getAlgorithm());
    }

    public static Cipher newCipher(CryptModel<Cipher, String> model) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        KeySpec keySpec = KeySpecFactory.newPBEKeySpec(model.getKey(), model.getSalt(), model.getIterationCount());
        SecretKeyFactory factory = SecretKeyFactoryExtensions.newSecretKeyFactory(model.getAlgorithm().getAlgorithm());
        SecretKey key = factory.generateSecret(keySpec);
        AlgorithmParameterSpec paramSpec = AlgorithmParameterSpecFactory.newPBEParameterSpec(model.getSalt(), model.getIterationCount());
        return CipherFactory.newCipher(model.getOperationMode(), key, paramSpec, key.getAlgorithm());
    }

    private CipherFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

