/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.obfuscation.rule;

import de.alpharogroup.collections.set.SetExtensions;
import de.alpharogroup.crypto.obfuscation.rule.ObfuscationRule;
import de.alpharogroup.crypto.obfuscation.rule.Operation;
import java.util.Set;

public class ObfuscationOperationRule<C, RW>
extends ObfuscationRule<C, RW> {
    private static final long serialVersionUID = 1L;
    private Set<Integer> indexes;
    private Operation operation;

    public ObfuscationOperationRule(C character, RW replaceWith, Operation operation, Set<Integer> indexes) {
        super(character, replaceWith);
        this.indexes = SetExtensions.newHashSet(indexes, (Object[])new Integer[0]);
        this.operation = operation;
    }

    public static <C, RW> ObfuscationOperationRuleBuilder<C, RW> newRule() {
        return new ObfuscationOperationRuleBuilder();
    }

    public Set<Integer> getIndexes() {
        return this.indexes;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setIndexes(Set<Integer> indexes) {
        this.indexes = indexes;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObfuscationOperationRule)) {
            return false;
        }
        ObfuscationOperationRule other = (ObfuscationOperationRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set<Integer> this$indexes = this.getIndexes();
        Set<Integer> other$indexes = other.getIndexes();
        if (this$indexes == null ? other$indexes != null : !((Object)this$indexes).equals(other$indexes)) {
            return false;
        }
        Operation this$operation = this.getOperation();
        Operation other$operation = other.getOperation();
        return !(this$operation == null ? other$operation != null : !this$operation.equals(other$operation));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObfuscationOperationRule;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Set<Integer> $indexes = this.getIndexes();
        result = result * 59 + ($indexes == null ? 43 : ((Object)$indexes).hashCode());
        Operation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ObfuscationOperationRule(super=" + super.toString() + ", indexes=" + this.getIndexes() + ", operation=" + this.getOperation() + ")";
    }

    public ObfuscationOperationRule() {
    }

    public static class ObfuscationOperationRuleBuilder<C, RW> {
        private C character;
        private RW replaceWith;
        private Operation operation;
        private Set<Integer> indexes;

        ObfuscationOperationRuleBuilder() {
        }

        public ObfuscationOperationRuleBuilder<C, RW> character(C character) {
            this.character = character;
            return this;
        }

        public ObfuscationOperationRuleBuilder<C, RW> replaceWith(RW replaceWith) {
            this.replaceWith = replaceWith;
            return this;
        }

        public ObfuscationOperationRuleBuilder<C, RW> operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public ObfuscationOperationRuleBuilder<C, RW> indexes(Set<Integer> indexes) {
            this.indexes = indexes;
            return this;
        }

        public ObfuscationOperationRule<C, RW> build() {
            return new ObfuscationOperationRule<C, RW>(this.character, this.replaceWith, this.operation, this.indexes);
        }

        public String toString() {
            return "ObfuscationOperationRule.ObfuscationOperationRuleBuilder(character=" + this.character + ", replaceWith=" + this.replaceWith + ", operation=" + this.operation + ", indexes=" + this.indexes + ")";
        }
    }
}

