/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key.writer;

import de.alpharogroup.file.write.WriteFileExtensions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import lombok.NonNull;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public final class PublicKeyWriter {
    public static void write(PublicKey publicKey, @NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        PublicKeyWriter.write(publicKey, new FileOutputStream(file));
    }

    public static void write(PublicKey publicKey, @NonNull OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        byte[] publicKeyBytes = publicKey.getEncoded();
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
        outputStream.write(keySpec.getEncoded());
        outputStream.close();
    }

    public static void writeInPemFormat(PublicKey publicKey, @NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        StringWriter stringWriter = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);
        pemWriter.writeObject((Object)publicKey);
        pemWriter.close();
        String pemFormat = stringWriter.toString();
        pemFormat = pemFormat.replaceAll("\\r\\n", "\\\n");
        WriteFileExtensions.string2File((File)file, (String)pemFormat);
    }

    private PublicKeyWriter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

