/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key.writer;

import de.alpharogroup.crypto.key.KeyFileFormat;
import de.alpharogroup.crypto.key.KeyFormat;
import de.alpharogroup.file.write.WriteFileExtensions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import lombok.NonNull;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public final class PrivateKeyWriter {
    public static void write(PrivateKey privateKey, @NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        PrivateKeyWriter.write(privateKey, new FileOutputStream(file));
    }

    public static void write(PrivateKey privateKey, @NonNull OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        byte[] privateKeyBytes = privateKey.getEncoded();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        outputStream.write(keySpec.getEncoded());
        outputStream.close();
    }

    public static void writeInPemFormat(PrivateKey privateKey, @NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        StringWriter stringWriter = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);
        pemWriter.writeObject((Object)privateKey);
        pemWriter.close();
        String pemFormat = stringWriter.toString();
        pemFormat = pemFormat.replaceAll("\\r\\n", "\\\n");
        WriteFileExtensions.string2File((File)file, (String)pemFormat);
    }

    public static void write(PrivateKey privateKey, @NonNull OutputStream outputStream, KeyFileFormat fileFormat, KeyFormat keyFormat) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        byte[] privateKeyBytes = privateKey.getEncoded();
        switch (fileFormat) {
            case DER: 
            case PEM: {
                if (keyFormat != null) {
                    if (keyFormat.equals((Object)KeyFormat.PKCS_8)) {
                        outputStream.write("-----BEGIN PRIVATE KEY-----".getBytes(StandardCharsets.US_ASCII));
                        outputStream.write(Base64.encodeBase64((byte[])privateKeyBytes, (boolean)true));
                        outputStream.write("-----END PRIVATE KEY-----".getBytes(StandardCharsets.US_ASCII));
                        break;
                    }
                    if (keyFormat.equals((Object)KeyFormat.PKCS_1)) {
                        outputStream.write("-----BEGIN RSA PRIVATE KEY-----\n".getBytes(StandardCharsets.US_ASCII));
                        outputStream.write(Base64.encodeBase64((byte[])privateKeyBytes, (boolean)true));
                        outputStream.write("\n-----END RSA PRIVATE KEY-----".getBytes(StandardCharsets.US_ASCII));
                        break;
                    }
                }
            }
            default: {
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
                outputStream.write(keySpec.getEncoded());
            }
        }
        outputStream.close();
    }

    private PrivateKeyWriter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

