/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key.writer;

import de.alpharogroup.crypto.key.KeyFileFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import lombok.NonNull;
import org.apache.commons.codec.binary.Base64;

public class CertificateWriter {
    public static void write(X509Certificate certificate, @NonNull File file, KeyFileFormat fileFormat) throws IOException, CertificateEncodingException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        CertificateWriter.write(certificate, new FileOutputStream(file), fileFormat);
    }

    public static void write(X509Certificate certificate, @NonNull OutputStream outputStream, KeyFileFormat fileFormat) throws IOException, CertificateEncodingException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        byte[] certificateBytes = certificate.getEncoded();
        switch (fileFormat) {
            case DER: {
                outputStream.write(certificateBytes);
                break;
            }
            case PEM: {
                outputStream.write("-----BEGIN CERTIFICATE-----\n".getBytes(StandardCharsets.US_ASCII));
                outputStream.write(Base64.encodeBase64((byte[])certificateBytes, (boolean)true));
                outputStream.write("-----END CERTIFICATE-----".getBytes(StandardCharsets.US_ASCII));
                break;
            }
            default: {
                outputStream.write(certificateBytes);
            }
        }
        outputStream.close();
    }

    public static void writeInDerFormat(X509Certificate certificate, @NonNull File file) throws IOException, CertificateEncodingException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        CertificateWriter.writeInDerFormat(certificate, new FileOutputStream(file));
    }

    public static void writeInDerFormat(X509Certificate certificate, @NonNull OutputStream outputStream) throws IOException, CertificateEncodingException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        CertificateWriter.write(certificate, outputStream, KeyFileFormat.DER);
    }

    public static void writeInPemFormat(X509Certificate certificate, @NonNull File file) throws IOException, CertificateEncodingException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        CertificateWriter.writeInPemFormat(certificate, new FileOutputStream(file));
    }

    public static void writeInPemFormat(X509Certificate certificate, @NonNull OutputStream outputStream) throws IOException, CertificateEncodingException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        CertificateWriter.write(certificate, outputStream, KeyFileFormat.PEM);
    }
}

