/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key.reader;

import de.alpharogroup.crypto.algorithm.KeyPairGeneratorAlgorithm;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public final class PrivateKeyReader {
    public static final String RSA_PRIVATE_KEY = "RSA PRIVATE KEY";
    public static final String BEGIN_PRIVATE_KEY_PREFIX = "-----BEGIN PRIVATE KEY-----";
    public static final String END_PRIVATE_KEY_SUFFIX = "-----END PRIVATE KEY-----";
    public static final String BEGIN_RSA_PRIVATE_KEY_PREFIX = "-----BEGIN RSA PRIVATE KEY-----\n";
    public static final String END_RSA_PRIVATE_KEY_SUFFIX = "\n-----END RSA PRIVATE KEY-----";

    public static PrivateKey readPrivateKey(File file) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        return PrivateKeyReader.readPrivateKey(file, KeyPairGeneratorAlgorithm.RSA.getAlgorithm());
    }

    public static PrivateKey readPrivateKey(File file, String algorithm) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        byte[] keyBytes = Files.readAllBytes(file.toPath());
        return PrivateKeyReader.readPrivateKey(keyBytes, algorithm);
    }

    public static PrivateKey readPrivateKey(byte[] privateKeyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        return PrivateKeyReader.readPrivateKey(privateKeyBytes, KeyPairGeneratorAlgorithm.RSA.getAlgorithm());
    }

    public static PrivateKey readPrivateKey(byte[] privateKeyBytes, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static PrivateKey readPemPrivateKey(File file) throws Exception {
        String privateKeyAsString = PrivateKeyReader.readPemFileAsBase64(file);
        byte[] decoded = new Base64().decode(privateKeyAsString);
        return PrivateKeyReader.readPrivateKey(decoded);
    }

    public static PrivateKey readPemPrivateKey(File file, String algorithm) throws Exception {
        String privateKeyAsString = PrivateKeyReader.readPemFileAsBase64(file);
        return PrivateKeyReader.readPemPrivateKey(privateKeyAsString, algorithm);
    }

    public static PrivateKey readPemPrivateKey(String privateKeyAsString, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        byte[] decoded = new Base64().decode(privateKeyAsString);
        return PrivateKeyReader.readPrivateKey(decoded, algorithm);
    }

    public static String readPemFileAsBase64(File file) throws IOException {
        byte[] keyBytes = Files.readAllBytes(file.toPath());
        String privateKeyPem = new String(keyBytes);
        String privateKeyAsBase64String = null;
        if (privateKeyPem.indexOf(BEGIN_PRIVATE_KEY_PREFIX) != -1) {
            privateKeyAsBase64String = new String(keyBytes).replace(BEGIN_PRIVATE_KEY_PREFIX, "").replace(END_PRIVATE_KEY_SUFFIX, "").trim();
        }
        if (privateKeyPem.indexOf(BEGIN_RSA_PRIVATE_KEY_PREFIX) != -1) {
            privateKeyAsBase64String = new String(keyBytes).replace(BEGIN_RSA_PRIVATE_KEY_PREFIX, "").replace(END_RSA_PRIVATE_KEY_SUFFIX, "").trim();
        }
        return privateKeyAsBase64String;
    }

    public static PrivateKey readPrivateKey(File root, String directory, String fileName) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException, IOException {
        File privatekeyDir = new File(root, directory);
        File privatekeyFile = new File(privatekeyDir, fileName);
        PrivateKey privateKey = PrivateKeyReader.readPrivateKey(privatekeyFile);
        return privateKey;
    }

    private PrivateKeyReader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

