/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.hash;

import de.alpharogroup.crypto.algorithm.HashAlgorithm;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;

public final class HashExtensions {
    public static byte[] hash(byte[] hashIt, HashAlgorithm hashAlgorithm) throws NoSuchAlgorithmException {
        return HashExtensions.hash(hashIt, null, hashAlgorithm, null);
    }

    public static byte[] hash(byte[] hashIt, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm.getAlgorithm());
        messageDigest.reset();
        if (salt != null) {
            messageDigest.update(salt.getBytes(charset));
        }
        messageDigest.update(hashIt);
        byte[] digestBytes = messageDigest.digest();
        return digestBytes;
    }

    public static String hash(String hashIt, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm.getAlgorithm());
        messageDigest.reset();
        messageDigest.update(salt.getBytes(charset));
        return new String(messageDigest.digest(hashIt.getBytes(charset)), charset);
    }

    public static String hashAndBase64(String hashIt, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException {
        String hashedAndBase64 = new Base64().encodeToString(HashExtensions.hash(hashIt, salt, hashAlgorithm, charset).getBytes(charset));
        return hashedAndBase64;
    }

    private HashExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

