/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import lombok.NonNull;
import org.apache.log4j.Logger;

public class SecureRandomBean {
    public static final String DEFAULT_ALGORITHM = "SHA1PRNG";
    private static final Logger logger = Logger.getLogger((String)SecureRandomBean.class.getName());
    private String algorithm;
    private String provider;

    public static SecureRandomBean builder() {
        return new SecureRandomBean();
    }

    private SecureRandomBean() {
    }

    public SecureRandomBean algorithm(@NonNull String algorithm) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm");
        }
        this.algorithm = algorithm;
        return this;
    }

    public SecureRandom build() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (this.algorithm != null && this.provider != null) {
            return SecureRandom.getInstance(this.algorithm, this.provider);
        }
        if (this.algorithm != null) {
            return SecureRandom.getInstance(this.algorithm);
        }
        return SecureRandom.getInstance(DEFAULT_ALGORITHM);
    }

    public SecureRandom buildQueitly() {
        SecureRandom secureRandom = null;
        try {
            secureRandom = this.build();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)"The specified algorithm is not available from the specified provider.", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            logger.error((Object)"The specified provider is not registered in the security provider list.", (Throwable)e);
        }
        return secureRandom;
    }

    public SecureRandomBean provider(@NonNull String provider) {
        if (provider == null) {
            throw new NullPointerException("provider");
        }
        this.provider = provider;
        return this;
    }
}

