/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.model;

import de.alpharogroup.crypto.algorithm.Algorithm;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;

public class CryptModel<C, K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private C cipher;
    private K key;
    private Algorithm algorithm;
    private int operationMode;
    private Integer iterationCount;
    byte[] salt;
    private boolean initialized;

    public static <C, K> CryptModelBuilder<C, K> builder() {
        return new CryptModelBuilder();
    }

    public C getCipher() {
        return this.cipher;
    }

    public K getKey() {
        return this.key;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public int getOperationMode() {
        return this.operationMode;
    }

    public Integer getIterationCount() {
        return this.iterationCount;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setCipher(C cipher) {
        this.cipher = cipher;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public void setOperationMode(int operationMode) {
        this.operationMode = operationMode;
    }

    public void setIterationCount(Integer iterationCount) {
        this.iterationCount = iterationCount;
    }

    public void setSalt(byte[] salt) {
        this.salt = salt;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CryptModel)) {
            return false;
        }
        CryptModel other = (CryptModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        C this$cipher = this.getCipher();
        C other$cipher = other.getCipher();
        if (this$cipher == null ? other$cipher != null : !this$cipher.equals(other$cipher)) {
            return false;
        }
        K this$key = this.getKey();
        K other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Algorithm this$algorithm = this.getAlgorithm();
        Algorithm other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        if (this.getOperationMode() != other.getOperationMode()) {
            return false;
        }
        Integer this$iterationCount = this.getIterationCount();
        Integer other$iterationCount = other.getIterationCount();
        if (this$iterationCount == null ? other$iterationCount != null : !((Object)this$iterationCount).equals(other$iterationCount)) {
            return false;
        }
        if (!Arrays.equals(this.getSalt(), other.getSalt())) {
            return false;
        }
        return this.isInitialized() == other.isInitialized();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CryptModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        C $cipher = this.getCipher();
        result = result * 59 + ($cipher == null ? 43 : $cipher.hashCode());
        K $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Algorithm $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        result = result * 59 + this.getOperationMode();
        Integer $iterationCount = this.getIterationCount();
        result = result * 59 + ($iterationCount == null ? 43 : ((Object)$iterationCount).hashCode());
        result = result * 59 + Arrays.hashCode(this.getSalt());
        result = result * 59 + (this.isInitialized() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "CryptModel(cipher=" + this.getCipher() + ", key=" + this.getKey() + ", algorithm=" + this.getAlgorithm() + ", operationMode=" + this.getOperationMode() + ", iterationCount=" + this.getIterationCount() + ", salt=" + Arrays.toString(this.getSalt()) + ", initialized=" + this.isInitialized() + ")";
    }

    public CryptModel() {
    }

    @ConstructorProperties(value={"cipher", "key", "algorithm", "operationMode", "iterationCount", "salt", "initialized"})
    public CryptModel(C cipher, K key, Algorithm algorithm, int operationMode, Integer iterationCount, byte[] salt, boolean initialized) {
        this.cipher = cipher;
        this.key = key;
        this.algorithm = algorithm;
        this.operationMode = operationMode;
        this.iterationCount = iterationCount;
        this.salt = salt;
        this.initialized = initialized;
    }

    public static class CryptModelBuilder<C, K> {
        private C cipher;
        private K key;
        private Algorithm algorithm;
        private int operationMode;
        private Integer iterationCount;
        private byte[] salt;
        private boolean initialized;

        CryptModelBuilder() {
        }

        public CryptModelBuilder<C, K> cipher(C cipher) {
            this.cipher = cipher;
            return this;
        }

        public CryptModelBuilder<C, K> key(K key) {
            this.key = key;
            return this;
        }

        public CryptModelBuilder<C, K> algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public CryptModelBuilder<C, K> operationMode(int operationMode) {
            this.operationMode = operationMode;
            return this;
        }

        public CryptModelBuilder<C, K> iterationCount(Integer iterationCount) {
            this.iterationCount = iterationCount;
            return this;
        }

        public CryptModelBuilder<C, K> salt(byte[] salt) {
            this.salt = salt;
            return this;
        }

        public CryptModelBuilder<C, K> initialized(boolean initialized) {
            this.initialized = initialized;
            return this;
        }

        public CryptModel<C, K> build() {
            return new CryptModel<C, K>(this.cipher, this.key, this.algorithm, this.operationMode, this.iterationCount, this.salt, this.initialized);
        }

        public String toString() {
            return "CryptModel.CryptModelBuilder(cipher=" + this.cipher + ", key=" + this.key + ", algorithm=" + this.algorithm + ", operationMode=" + this.operationMode + ", iterationCount=" + this.iterationCount + ", salt=" + Arrays.toString(this.salt) + ", initialized=" + this.initialized + ")";
        }
    }
}

