/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import lombok.NonNull;

public final class PublicKeyWriter {
    public static void write(PublicKey publicKey, @NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        PublicKeyWriter.write(publicKey, new FileOutputStream(file));
    }

    public static void write(PublicKey publicKey, @NonNull OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        byte[] publicKeyBytes = publicKey.getEncoded();
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
        outputStream.write(keySpec.getEncoded());
        outputStream.close();
    }

    private PublicKeyWriter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

