/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import lombok.NonNull;

public final class PrivateKeyWriter {
    public static void write(PrivateKey privateKey, @NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        PrivateKeyWriter.write(privateKey, new FileOutputStream(file));
    }

    public static void write(PrivateKey privateKey, @NonNull OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        byte[] privateKeyBytes = privateKey.getEncoded();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        outputStream.write(keySpec.getEncoded());
        outputStream.close();
    }

    private PrivateKeyWriter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

