/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key.reader;

import de.alpharogroup.crypto.algorithm.KeyPairGeneratorAlgorithm;
import de.alpharogroup.crypto.provider.SecurityProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public final class PublicKeyReader {
    public static final String END_PUBLIC_KEY_SUFFIX = "-----END PUBLIC KEY-----";
    public static final String BEGIN_PUBLIC_KEY_PREFIX = "-----BEGIN PUBLIC KEY-----\n";

    public static PublicKey readPublicKey(File file) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        byte[] keyBytes = Files.readAllBytes(file.toPath());
        return PublicKeyReader.readPublicKey(keyBytes, "BC");
    }

    public static PublicKey readPublicKey(byte[] publicKeyBytes, SecurityProvider securityProvider) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        return PublicKeyReader.readPublicKey(publicKeyBytes, securityProvider.name());
    }

    public static PublicKey readPublicKey(byte[] publicKeyBytes, String provider) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        return PublicKeyReader.readPublicKey(publicKeyBytes, provider, KeyPairGeneratorAlgorithm.RSA.getAlgorithm());
    }

    public static PublicKey readPublicKey(byte[] publicKeyBytes, String provider, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    public static PublicKey readPemPublicKey(File file, SecurityProvider securityProvider) throws Exception {
        String publicKeyAsString = PublicKeyReader.readPemFileAsBase64(file);
        byte[] decoded = Base64.decodeBase64((String)publicKeyAsString);
        return PublicKeyReader.readPublicKey(decoded, securityProvider);
    }

    public static String readPemFileAsBase64(File file) throws IOException {
        byte[] keyBytes = Files.readAllBytes(file.toPath());
        String publicKeyAsBase64String = new String(keyBytes).replace(BEGIN_PUBLIC_KEY_PREFIX, "").replace(END_PUBLIC_KEY_SUFFIX, "");
        return publicKeyAsBase64String;
    }

    public static PublicKey readPemPublicKey(File file) throws Exception {
        return PublicKeyReader.readPemPublicKey(file, SecurityProvider.BC);
    }

    private PublicKeyReader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

