/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key;

import de.alpharogroup.crypto.hex.HexExtensions;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public final class PublicKeyExtensions {
    public static int getKeyLength(PublicKey publicKey) {
        int length = -1;
        if (publicKey == null) {
            return length;
        }
        if (publicKey instanceof RSAPublicKey) {
            length = ((RSAPublicKey)publicKey).getModulus().bitLength();
        }
        if (publicKey instanceof DSAPublicKey) {
            length = ((DSAPublicKey)publicKey).getParams().getP().bitLength();
        }
        if (publicKey instanceof ECPublicKey) {
            length = ((ECPublicKey)publicKey).getParams().getCurve().getField().getFieldSize();
        }
        return length;
    }

    public static String toHexString(PublicKey publicKey) {
        return PublicKeyExtensions.toHexString(publicKey, true);
    }

    public static String toBase64(PublicKey publicKey) {
        byte[] encoded = publicKey.getEncoded();
        String publicKeyAsBase64String = Base64.encodeBase64String((byte[])encoded);
        return publicKeyAsBase64String;
    }

    public static String toPemFormat(PublicKey publicKey) {
        String publicKeyAsBase64String = PublicKeyExtensions.toBase64(publicKey);
        List<String> parts = PublicKeyExtensions.splitByFixedLength(publicKeyAsBase64String, 64);
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN PUBLIC KEY-----\n");
        for (String part : parts) {
            sb.append(part);
            sb.append(System.lineSeparator());
        }
        sb.append("-----END PUBLIC KEY-----");
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    public static String toHexString(PublicKey publicKey, boolean lowerCase) {
        String hexString = HexExtensions.toHexString(publicKey.getEncoded(), lowerCase);
        return hexString;
    }

    @Deprecated
    public static List<String> splitByFixedLength(String input, int fixedLength) {
        ArrayList<String> parts = new ArrayList<String>();
        for (int beginIndex = 0; beginIndex < input.length(); beginIndex += fixedLength) {
            int endIndex = Math.min(beginIndex + fixedLength, input.length());
            String part = input.substring(beginIndex, endIndex);
            parts.add(part);
        }
        return parts;
    }

    private PublicKeyExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

