/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.factories;

import de.alpharogroup.crypto.algorithm.Algorithm;
import de.alpharogroup.crypto.key.reader.PrivateKeyReader;
import de.alpharogroup.crypto.key.reader.PublicKeyReader;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;

public final class KeyPairFactory {
    public static KeyPair newKeyPair(Algorithm algorithm, int keySize) throws NoSuchAlgorithmException {
        return KeyPairFactory.newKeyPair(algorithm.getAlgorithm(), keySize);
    }

    public static KeyPair newKeyPair(String algorithm, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairFactory.newKeyPairGenerator(algorithm, keySize);
        return generator.generateKeyPair();
    }

    public static KeyPair newKeyPair(PublicKey publicKey, PrivateKey privateKey) {
        KeyPair keyPair = new KeyPair(publicKey, privateKey);
        return keyPair;
    }

    public static KeyPair newKeyPair(File publicKeyDerFile, File privateKeyDerFile) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException, IOException {
        PublicKey publicKey = PublicKeyReader.readPublicKey(publicKeyDerFile);
        PrivateKey privateKey = PrivateKeyReader.readPrivateKey(privateKeyDerFile);
        return KeyPairFactory.newKeyPair(publicKey, privateKey);
    }

    public static KeyPairGenerator newKeyPairGenerator(String algorithm, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(algorithm);
        generator.initialize(keySize);
        return generator;
    }

    public static KeyPairGenerator newKeyPairGenerator(String algorithm, int keySize, SecureRandom secureRandom) throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(algorithm);
        generator.initialize(keySize, secureRandom);
        return generator;
    }

    private KeyPairFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

