/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.factories;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public final class CertFactory {
    public static X509Certificate newX509Certificate(String type, byte[] certificateData) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance(type);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(certificateData);
        X509Certificate certificate = (X509Certificate)cf.generateCertificate(inputStream);
        return certificate;
    }

    public static X509Certificate newX509Certificate(PublicKey publicKey, PrivateKey privateKey, BigInteger serialNumber, String subject, String issuer, String signatureAlgorithm, Date start, Date end) throws Exception {
        X500Principal subjectPrincipal = new X500Principal(subject);
        X500Principal issuerPrincipal = new X500Principal(issuer);
        X509V3CertificateGenerator certificateGenerator = new X509V3CertificateGenerator();
        certificateGenerator.setPublicKey(publicKey);
        certificateGenerator.setSerialNumber(serialNumber);
        certificateGenerator.setSubjectDN(subjectPrincipal);
        certificateGenerator.setIssuerDN(issuerPrincipal);
        certificateGenerator.setNotBefore(start);
        certificateGenerator.setNotAfter(end);
        certificateGenerator.setSignatureAlgorithm(signatureAlgorithm);
        X509Certificate certificate = certificateGenerator.generate(privateKey);
        return certificate;
    }

    private CertFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

