/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key;

import de.alpharogroup.crypto.algorithm.KeyPairWithModeAndPaddingAlgorithm;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import lombok.NonNull;
import org.apache.commons.codec.binary.Hex;

public final class PublicKeyHexEncryptor {
    private Cipher cipher;
    private boolean initialized;
    private final PublicKey publicKey;

    public PublicKeyHexEncryptor(@NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        this.publicKey = publicKey;
    }

    public String encrypt(String string) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException, IOException {
        this.initialize();
        byte[] utf8 = string.getBytes("UTF-8");
        byte[] encrypt = this.cipher.doFinal(utf8);
        char[] original = Hex.encodeHex((byte[])encrypt, (boolean)false);
        return new String(original);
    }

    private void initialize() throws NoSuchAlgorithmException, InvalidKeySpecException, UnsupportedEncodingException, NoSuchPaddingException, InvalidKeyException {
        if (!this.isInitialized()) {
            this.cipher = Cipher.getInstance(KeyPairWithModeAndPaddingAlgorithm.RSA_ECB_OAEPWithSHA1AndMGF1Padding.getAlgorithm());
            this.cipher.init(1, this.publicKey);
            this.initialized = true;
        }
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }
}

