/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key;

import de.alpharogroup.crypto.algorithm.KeyPairWithModeAndPaddingAlgorithm;
import de.alpharogroup.crypto.hex.HexExtensions;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import lombok.NonNull;
import org.apache.commons.codec.DecoderException;

public final class PrivateKeyHexDecryptor {
    private Cipher cipher;
    private boolean initialized;
    private final PrivateKey privateKey;

    public PrivateKeyHexDecryptor(@NonNull PrivateKey privateKey) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked @NonNull but is null");
        }
        this.privateKey = privateKey;
    }

    public String decrypt(String encypted) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, DecoderException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, IOException {
        this.initialize();
        byte[] dec = HexExtensions.decodeHex((char[])encypted.toCharArray());
        byte[] utf8 = this.cipher.doFinal(dec);
        return new String(utf8, "UTF-8");
    }

    private void initialize() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException, IOException, InvalidAlgorithmParameterException {
        if (!this.isInitialized()) {
            this.cipher = Cipher.getInstance(KeyPairWithModeAndPaddingAlgorithm.RSA_ECB_OAEPWithSHA1AndMGF1Padding.getAlgorithm());
            this.cipher.init(2, this.privateKey);
            this.initialized = true;
        }
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

