/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.blockchain;

import de.alpharogroup.crypto.algorithm.HashAlgorithm;
import de.alpharogroup.crypto.blockchain.api.IAddress;
import de.alpharogroup.crypto.hash.HashExtensions;
import java.util.Arrays;

public class Address
implements IAddress {
    private byte[] hash;
    private String name;
    private byte[] publicKey;

    public Address(String name, byte[] publicKey) {
        this.name = name;
        this.publicKey = publicKey;
        this.hash = HashExtensions.hash((byte[])name.getBytes(), (byte[])publicKey, (HashAlgorithm)HashAlgorithm.SHA256);
    }

    public byte[] getHash() {
        return this.hash;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getHash(), other.getHash())) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        return Arrays.equals(this.getPublicKey(), other.getPublicKey());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Address;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getHash());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPublicKey());
        return result;
    }

    public Address() {
    }
}

