/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.ssl;

import de.alpharogroup.crypto.factories.KeyStoreFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public final class KeyTrustExtensions {
    public static TrustManager[] resolveTrustManagers(String keystoreType, String password, File keystoreFile, String trustManagerAlgorithm) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException {
        KeyStore keyStore = KeyStoreFactory.newKeyStore((String)keystoreType, (String)password, (File)keystoreFile);
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(trustManagerAlgorithm);
        trustFactory.init(keyStore);
        TrustManager[] trustManagers = trustFactory.getTrustManagers();
        return trustManagers;
    }

    public static KeyManager[] resolveKeyManagers(String keystoreType, String password, File keystoreFile, String keyManagerAlgorithm) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStoreFactory.newKeyStore((String)keystoreType, (String)password, (File)keystoreFile);
        KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
        keyFactory.init(keyStore, password.toCharArray());
        KeyManager[] keyManagers = keyFactory.getKeyManagers();
        return keyManagers;
    }

    private KeyTrustExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

