/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.file;

import de.alpharogroup.crypto.core.AbstractFileEncryptor;
import de.alpharogroup.crypto.io.CryptoCipherInputStream;
import de.alpharogroup.crypto.model.CryptModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.FilenameUtils;

public class FileEncryptor
extends AbstractFileEncryptor {
    private static final long serialVersionUID = 1L;
    private File encryptedFile;

    public FileEncryptor(CryptModel<Cipher, String> model) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
    }

    public FileEncryptor(CryptModel<Cipher, String> model, File encryptedFile) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
        this.encryptedFile = encryptedFile;
    }

    public File encrypt(File toEncrypt) throws Exception {
        int c;
        if (this.encryptedFile == null) {
            String filename = FilenameUtils.getBaseName((String)toEncrypt.getName());
            this.encryptedFile = this.newEncryptedFile(toEncrypt.getParent(), filename + ".enc");
        }
        FileInputStream fis = new FileInputStream(toEncrypt);
        CryptoCipherInputStream cis = new CryptoCipherInputStream(fis, (Cipher)this.getModel().getCipher());
        FileOutputStream out = new FileOutputStream(this.encryptedFile);
        while ((c = cis.read()) != -1) {
            ((OutputStream)out).write(c);
        }
        cis.close();
        ((OutputStream)out).close();
        return this.encryptedFile;
    }

    protected File newEncryptedFile(String parent, String child) {
        return new File(parent, child);
    }
}

