/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.obfuscation.experimental;

import com.google.common.collect.BiMap;
import de.alpharogroup.crypto.obfuscation.rule.ObfuscationOperationRule;
import de.alpharogroup.crypto.obfuscation.rule.Operation;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class ObfuscatorExtensions {
    public static String obfuscate(BiMap<String, String> rules, String toObfuscate) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toObfuscate.length(); ++i) {
            char currentCharacter = toObfuscate.charAt(i);
            String charAsString = Character.toString(currentCharacter);
            if (rules.containsKey((Object)charAsString)) {
                sb.append((String)rules.get((Object)charAsString));
                continue;
            }
            sb.append(charAsString);
        }
        return sb.toString();
    }

    public static String disentangle(BiMap<String, String> rules, String obfuscated) {
        String clonedObfuscated = obfuscated;
        for (Map.Entry rule : rules.entrySet()) {
            clonedObfuscated = StringUtils.replace((String)clonedObfuscated, (String)((String)rule.getValue()), (String)((String)rule.getKey()));
        }
        return clonedObfuscated;
    }

    public static String obfuscateWith(BiMap<Character, ObfuscationOperationRule<Character, Character>> rules, String toObfuscate) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toObfuscate.length(); ++i) {
            char currentCharacter = toObfuscate.charAt(i);
            Character asCharacter = Character.valueOf(currentCharacter);
            String charAsString = Character.toString(currentCharacter);
            if (rules.containsKey((Object)asCharacter)) {
                ObfuscationOperationRule obfuscationOperationRule = (ObfuscationOperationRule)rules.get((Object)asCharacter);
                Set indexes = obfuscationOperationRule.getIndexes();
                Operation operation = obfuscationOperationRule.getOperation();
                if (indexes.contains(i) && operation != null) {
                    sb.append(Operation.operate((char)currentCharacter, (Operation)operation));
                    continue;
                }
                Character replaceWith = (Character)obfuscationOperationRule.getReplaceWith();
                sb.append(replaceWith);
                continue;
            }
            sb.append(charAsString);
        }
        return sb.toString();
    }

    private ObfuscatorExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

