/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.core;

import de.alpharogroup.check.Check;
import de.alpharogroup.crypto.CryptConst;
import de.alpharogroup.crypto.algorithm.SunJCEAlgorithm;
import de.alpharogroup.crypto.api.Cryptor;
import de.alpharogroup.crypto.factories.AlgorithmParameterSpecFactory;
import de.alpharogroup.crypto.factories.SecretKeyFactoryExtensions;
import de.alpharogroup.crypto.model.CryptModel;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractCryptor<C, K>
implements Serializable,
Cryptor {
    private static final long serialVersionUID = 1L;
    protected final CryptModel<C, K> model;

    public AbstractCryptor(CryptModel<C, K> model) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        Check.get().notNull(model, "model").notNull(model.getKey(), "model.getKey()");
        this.model = model;
        this.onInitialize();
    }

    public AbstractCryptor(K key) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        Check.get().notNull(key, "key");
        this.model = CryptModel.builder().key(key).build();
        this.onInitialize();
    }

    protected String newAlgorithm() {
        if (this.getModel().getAlgorithm() == null) {
            return SunJCEAlgorithm.PBEWithMD5AndDES.getAlgorithm();
        }
        return this.getModel().getAlgorithm().getAlgorithm();
    }

    protected AlgorithmParameterSpec newAlgorithmParameterSpec(byte[] salt, int iterationCount) {
        return AlgorithmParameterSpecFactory.newPBEParameterSpec((byte[])salt, (int)iterationCount);
    }

    protected C newCipher(K key) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        return this.newCipher(key, this.newAlgorithm(), this.newSalt(), this.newIterationCount(), this.newOperationMode());
    }

    protected abstract C newCipher(K var1, String var2, byte[] var3, int var4, int var5) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException;

    protected int newIterationCount() {
        if (this.getModel().getIterationCount() == null) {
            return 19;
        }
        return this.getModel().getIterationCount();
    }

    protected byte[] newSalt() {
        if (ArrayUtils.isEmpty((byte[])this.getModel().getSalt())) {
            return CryptConst.SALT;
        }
        return this.getModel().getSalt();
    }

    protected SecretKeyFactory newSecretKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        return SecretKeyFactoryExtensions.newSecretKeyFactory((String)algorithm);
    }

    protected void onInitialize() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        this.model.setCipher(this.newCipher(this.model.getKey()));
        this.model.setInitialized(true);
    }

    public CryptModel<C, K> getModel() {
        return this.model;
    }
}

