/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.aes;

import de.alpharogroup.crypto.interfaces.Decryptor;
import java.util.Arrays;

public class ChainedDecryptor
implements Decryptor {
    private final Decryptor[] decryptors;

    public ChainedDecryptor(Decryptor ... decryptors) {
        this.decryptors = decryptors;
    }

    @Override
    public String decrypt(String encypted) throws Exception {
        String result = encypted;
        for (Decryptor encryptor : this.decryptors) {
            result = encryptor.decrypt(result);
        }
        return result;
    }

    public static ChainedDecryptorBuilder builder() {
        return new ChainedDecryptorBuilder();
    }

    public Decryptor[] getDecryptors() {
        return this.decryptors;
    }

    public static class ChainedDecryptorBuilder {
        private Decryptor[] decryptors;

        ChainedDecryptorBuilder() {
        }

        public ChainedDecryptorBuilder decryptors(Decryptor[] decryptors) {
            this.decryptors = decryptors;
            return this;
        }

        public ChainedDecryptor build() {
            return new ChainedDecryptor(this.decryptors);
        }

        public String toString() {
            return "ChainedDecryptor.ChainedDecryptorBuilder(decryptors=" + Arrays.deepToString(this.decryptors) + ")";
        }
    }
}

