/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.checksum;

import de.alpharogroup.checksum.ByteArrayChecksumExtensions;
import de.alpharogroup.crypto.algorithm.Algorithm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public final class ObjectChecksumExtensions {
    private ObjectChecksumExtensions() {
    }

    public static String getChecksum(String text, Algorithm algorithm) throws NoSuchAlgorithmException {
        return ObjectChecksumExtensions.getChecksum(text, algorithm.getAlgorithm());
    }

    public static long getChecksum(String text, boolean crc) {
        return crc ? ByteArrayChecksumExtensions.getCheckSumCRC32(text.getBytes()) : ByteArrayChecksumExtensions.getCheckSumAdler32(text.getBytes());
    }

    public static String getChecksum(String text, String algorithm) throws NoSuchAlgorithmException {
        return ByteArrayChecksumExtensions.getChecksum(text.getBytes(), algorithm);
    }

    public static <T extends Serializable> String getChecksum(T serializableObject, Algorithm algorithm) throws NoSuchAlgorithmException, IOException {
        return ObjectChecksumExtensions.getChecksum(serializableObject, algorithm.getAlgorithm());
    }

    public static <T extends Serializable> long getChecksum(T serializableObject, boolean crc) throws IOException {
        return crc ? ByteArrayChecksumExtensions.getCheckSumCRC32(ObjectChecksumExtensions.toByteArray(serializableObject)) : ByteArrayChecksumExtensions.getCheckSumAdler32(ObjectChecksumExtensions.toByteArray(serializableObject));
    }

    public static <T extends Serializable> String getChecksum(T serializableObject, String algorithm) throws NoSuchAlgorithmException, IOException {
        return ByteArrayChecksumExtensions.getChecksum(ObjectChecksumExtensions.toByteArray(serializableObject), algorithm);
    }

    public static <T extends Serializable> byte[] toByteArray(T object) throws IOException {
        Objects.requireNonNull(object);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }
}

