/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.checksum;

import de.alpharogroup.checksum.ByteArrayChecksumExtensions;
import de.alpharogroup.crypto.algorithm.Algorithm;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

public final class FileChecksumExtensions {
    private FileChecksumExtensions() {
    }

    public static String getChecksum(File file, Algorithm algorithm) throws NoSuchAlgorithmException, IOException {
        return FileChecksumExtensions.getChecksum(file, algorithm.getAlgorithm());
    }

    public static long getChecksum(File file, boolean crc) throws FileNotFoundException, IOException {
        try (CheckedInputStream cis = crc ? new CheckedInputStream(new FileInputStream(file), new CRC32()) : new CheckedInputStream(new FileInputStream(file), new Adler32());){
            long checksum;
            int length = (int)file.length();
            byte[] buffer = new byte[length];
            while (cis.read(buffer) >= 0) {
                checksum = cis.getChecksum().getValue();
            }
            long l = checksum = cis.getChecksum().getValue();
            return l;
        }
    }

    public static String getChecksum(File file, String algorithm) throws NoSuchAlgorithmException, IOException {
        return ByteArrayChecksumExtensions.getChecksum(Files.readAllBytes(file.toPath()), algorithm);
    }

    public static long getCheckSumAdler32(File file) throws IOException {
        return ByteArrayChecksumExtensions.getCheckSumAdler32(Files.readAllBytes(file.toPath()));
    }

    public static long getCheckSumCRC32(File file) throws IOException {
        return ByteArrayChecksumExtensions.getCheckSumCRC32(Files.readAllBytes(file.toPath()));
    }
}

