/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.checksum;

import de.alpharogroup.checksum.api.ChecksumAlgorithm;

public final class ChecksumExtensions {
    private static final String HEXADECIMAL_CHARACTER_CLASS = "[a-fA-F0-9]";
    private static final String REGEX_VALIDATION_MD5 = "[a-fA-F0-9]{32}";
    private static final String REGEX_VALIDATION_SHA1 = "[a-fA-F0-9]{40}";
    private static final String REGEX_VALIDATION_SHA256 = "[a-fA-F0-9]{64}";
    private static final String REGEX_VALIDATION_SHA384 = "[a-fA-F0-9]{96}";
    private static final String REGEX_VALIDATION_SHA512 = "[a-fA-F0-9]{128}";

    private ChecksumExtensions() {
    }

    public static boolean matchesMD5(String value) {
        return value.matches(REGEX_VALIDATION_MD5);
    }

    public static boolean matchesSHA1(String value) {
        return value.matches(REGEX_VALIDATION_SHA1);
    }

    public static boolean matchesSHA384(String value) {
        return value.matches(REGEX_VALIDATION_SHA384);
    }

    public static boolean matchesSHA256(String value) {
        return value.matches(REGEX_VALIDATION_SHA256);
    }

    public static boolean matchesSHA512(String value) {
        return value.matches(REGEX_VALIDATION_SHA512);
    }

    public static ChecksumAlgorithm resolveChecksumAlgorithm(String value) {
        if (ChecksumExtensions.matchesMD5(value)) {
            return ChecksumAlgorithm.MD5;
        }
        if (ChecksumExtensions.matchesSHA1(value)) {
            return ChecksumAlgorithm.SHA_1;
        }
        if (ChecksumExtensions.matchesSHA256(value)) {
            return ChecksumAlgorithm.SHA_256;
        }
        if (ChecksumExtensions.matchesSHA384(value)) {
            return ChecksumAlgorithm.SHA_384;
        }
        if (ChecksumExtensions.matchesSHA512(value)) {
            return ChecksumAlgorithm.SHA_512;
        }
        return ChecksumAlgorithm.UNDEFINED;
    }
}

