/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.checksum;

import de.alpharogroup.crypto.algorithm.Algorithm;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;
import java.util.zip.CRC32;

public final class ByteArrayChecksumExtensions {
    private ByteArrayChecksumExtensions() {
    }

    public static String getChecksum(Algorithm algorithm, byte[] ... byteArrays) throws NoSuchAlgorithmException {
        StringBuilder sb = new StringBuilder();
        for (byte[] byteArray : byteArrays) {
            sb.append(ByteArrayChecksumExtensions.getChecksum(byteArray, algorithm.getAlgorithm()));
        }
        return sb.toString();
    }

    public static String getChecksum(byte[] bytes, Algorithm algorithm) throws NoSuchAlgorithmException {
        return ByteArrayChecksumExtensions.getChecksum(bytes, algorithm.getAlgorithm());
    }

    public static String getChecksum(byte[] bytes, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        messageDigest.reset();
        messageDigest.update(bytes);
        byte[] digest = messageDigest.digest();
        StringBuilder hexView = new StringBuilder();
        for (byte element : digest) {
            String intAsHex = Integer.toHexString(0xFF & element);
            if (intAsHex.length() == 1) {
                hexView.append('0');
            }
            hexView.append(intAsHex);
        }
        return hexView.toString();
    }

    public static String getChecksum(Byte[] bytes, Algorithm algorithm) throws NoSuchAlgorithmException {
        return ByteArrayChecksumExtensions.getChecksum(bytes, algorithm.getAlgorithm());
    }

    public static String getChecksum(Byte[] bytes, String algorithm) throws NoSuchAlgorithmException {
        return ByteArrayChecksumExtensions.getChecksum(ByteArrayChecksumExtensions.toByteArray(bytes), algorithm);
    }

    public static long getCheckSumAdler32(byte[] bytes) {
        Adler32 checksum = new Adler32();
        checksum.update(bytes, 0, bytes.length);
        return checksum.getValue();
    }

    public static long getCheckSumCRC32(byte[] bytes) {
        CRC32 checksum = new CRC32();
        checksum.update(bytes, 0, bytes.length);
        return checksum.getValue();
    }

    private static byte[] toByteArray(Byte[] bytes) {
        byte[] byteArray = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            byteArray[i] = bytes[i];
        }
        return byteArray;
    }
}

