/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.c10n.iface.generator.util;

import c10n.annotations.De;
import c10n.annotations.En;
import c10n.annotations.Fr;
import c10n.annotations.It;
import c10n.annotations.Ja;
import c10n.annotations.Ko;
import c10n.annotations.Ru;
import c10n.annotations.Zh;
import de.alpharogroup.file.search.FileSearchUtils;
import de.alpharogroup.lang.PropertiesUtils;
import de.alpharogroup.locale.Locales;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class PropertiesValidation {
    public static final Map<Locale, Class<?>> localeToannotation = new HashMap<Locale, Class<?>>(){
        {
            this.put(Locale.ENGLISH, En.class);
            this.put(Locale.GERMAN, De.class);
            this.put(Locale.FRENCH, Fr.class);
            this.put(Locale.ITALIAN, It.class);
            this.put(Locale.JAPANESE, Ja.class);
            this.put(Locale.KOREAN, Ko.class);
            this.put(Locales.RUSSIAN, Ru.class);
            this.put(Locale.CHINESE, Zh.class);
        }
    };

    public static List<File> findFiles(File rootDir) {
        String pattern = "*.properties";
        List foundedFiles = FileSearchUtils.findFilesRecursive((File)rootDir, (String)"*.properties");
        return foundedFiles;
    }

    public static Map<String, List<Properties>> getMapForC10NInterfaceGeneration(Collection<File> propertiesFiles) throws IOException {
        LinkedHashMap<String, List<Properties>> propertiesWithAnnotationNames = new LinkedHashMap<String, List<Properties>>();
        for (File propertiesFile : propertiesFiles) {
            Properties properties = PropertiesUtils.loadProperties((File)propertiesFile);
            Locale locale = PropertiesUtils.getLocale((File)propertiesFile);
            if (!localeToannotation.containsKey(locale)) continue;
            Class<?> c10nAnnotation = localeToannotation.get(locale);
            if (!propertiesWithAnnotationNames.containsKey(c10nAnnotation.getSimpleName())) {
                propertiesWithAnnotationNames.put(c10nAnnotation.getSimpleName(), new ArrayList());
            }
            ((List)propertiesWithAnnotationNames.get(c10nAnnotation.getSimpleName())).add(properties);
        }
        return propertiesWithAnnotationNames;
    }

    public static Map<String, List<Properties>> getMapForC10NInterfaceGeneration(File rootDir) throws IOException {
        List<File> propertiesFiles = PropertiesValidation.findFiles(rootDir);
        return PropertiesValidation.getMapForC10NInterfaceGeneration(propertiesFiles);
    }

    public static Map<Properties, Locale> mapWithLocales(Collection<File> propertiesFiles) throws IOException {
        HashMap<Properties, Locale> propertiesToLocales = new HashMap<Properties, Locale>();
        for (File propertiesFile : propertiesFiles) {
            Properties properties = PropertiesUtils.loadProperties((File)propertiesFile);
            Locale locale = PropertiesUtils.getLocale((File)propertiesFile);
            propertiesToLocales.put(properties, locale);
        }
        return propertiesToLocales;
    }

    public static Collection<File> validate(File rootDir) throws IOException {
        return null;
    }
}

