/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.c10n.iface.generator;

import c10n.annotations.De;
import c10n.annotations.En;
import c10n.annotations.Fr;
import c10n.annotations.It;
import c10n.annotations.Ja;
import c10n.annotations.Ko;
import c10n.annotations.Ru;
import c10n.annotations.Zh;
import com.google.common.io.Files;
import de.alpharogroup.file.FileExtension;
import de.alpharogroup.lang.PropertiesUtils;
import de.alpharogroup.lang.model.AnnotationModel;
import de.alpharogroup.lang.model.ClassModel;
import de.alpharogroup.lang.model.MethodModel;
import de.alpharogroup.locale.Locales;
import de.alpharogroup.string.StringExtensions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class C10NInterfaceGenerator {
    Map<String, ClassModel> interfaces = new LinkedHashMap<String, ClassModel>();
    Map<String, Properties> propertiesWithAnnotationNames;
    Map<String, Class<?>> stringToAnnotationClass = new HashMap<String, Class<?>>(){
        {
            this.put("En", En.class);
            this.put("De", De.class);
            this.put("Fr", Fr.class);
            this.put("It", It.class);
            this.put("Ja", Ja.class);
            this.put("Ko", Ko.class);
            this.put("Ru", Ru.class);
            this.put("Zh", Zh.class);
        }
    };
    Map<Class<?>, Locale> annotationToLocale = new HashMap<Class<?>, Locale>(){
        {
            this.put(En.class, Locale.ENGLISH);
            this.put(De.class, Locale.GERMAN);
            this.put(Fr.class, Locale.FRENCH);
            this.put(It.class, Locale.ITALIAN);
            this.put(Ja.class, Locale.JAPANESE);
            this.put(Ko.class, Locale.KOREAN);
            this.put(Ru.class, Locales.RUSSIAN);
            this.put(Zh.class, Locale.CHINESE);
        }
    };
    Map<Locale, Class<?>> localeToannotation = new HashMap<Locale, Class<?>>(){
        {
            this.put(Locale.ENGLISH, En.class);
            this.put(Locale.GERMAN, De.class);
            this.put(Locale.FRENCH, Fr.class);
            this.put(Locale.ITALIAN, It.class);
            this.put(Locale.JAPANESE, Ja.class);
            this.put(Locale.KOREAN, Ko.class);
            this.put(Locales.RUSSIAN, Ru.class);
            this.put(Locale.CHINESE, Zh.class);
        }
    };
    String sourceFolderForInterfaces;

    public C10NInterfaceGenerator(Map<String, Properties> propertiesWithAnnotationNames, String sourceFolderForInterfaces) {
        if (propertiesWithAnnotationNames == null || propertiesWithAnnotationNames.isEmpty()) {
            throw new IllegalArgumentException("propertiesWithAnnotationNames should not be null or empty.");
        }
        if (sourceFolderForInterfaces == null || sourceFolderForInterfaces.isEmpty()) {
            throw new IllegalArgumentException("sourceFolderForInterfaces should not be null or empty.");
        }
        this.propertiesWithAnnotationNames = propertiesWithAnnotationNames;
        this.sourceFolderForInterfaces = sourceFolderForInterfaces;
        this.init();
    }

    public void generate() throws IOException {
        for (Map.Entry<String, ClassModel> entry : this.interfaces.entrySet()) {
            ClassModel classModel = entry.getValue();
            VelocityContext context = new VelocityContext();
            context.put("model", (Object)classModel);
            Template daoClassTemplate = Velocity.getTemplate((String)"src/main/resources/c10nInterface.vm");
            System.out.println(classModel);
            String packageAndClassName = classModel.getClassName().equalsIgnoreCase(classModel.getPackageName()) ? classModel.getPackageName() + "/" + classModel.getClassName() : classModel.getPackageName().replace('.', '/') + "/" + classModel.getClassName();
            File classFile = new File(this.sourceFolderForInterfaces + packageAndClassName + FileExtension.JAVA.getExtension());
            Files.createParentDirs((File)classFile);
            if (!classFile.exists()) {
                classFile.createNewFile();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(classFile));
            daoClassTemplate.merge((Context)context, (Writer)writer);
            writer.flush();
            writer.close();
        }
    }

    private void getClassModels(Map<String, List<String>> matchedPrefixes, String localeAnnotationName, Map<String, ClassModel> interfaces, Properties ruProperties) {
        for (Map.Entry<String, List<String>> entry : matchedPrefixes.entrySet()) {
            Object cn;
            AnnotationModel annotation;
            String propertyValue;
            String value2;
            String key = entry.getKey();
            List<String> propertyKeyValues = entry.getValue();
            ClassModel classModel = null;
            LinkedHashMap<String, MethodModel> methods = null;
            int lastIndex = key.lastIndexOf(".");
            String packageName = "";
            String interfaceName = null;
            String methodName = "";
            MethodModel method = null;
            if (0 < lastIndex) {
                interfaceName = StringExtensions.firstCharacterToUpperCase((String)key.substring(lastIndex + 1, key.length()));
                if (interfaces.containsKey(interfaceName)) {
                    classModel = interfaces.get(interfaceName);
                    methods = classModel.getMethods();
                    for (String value2 : propertyKeyValues) {
                        methodName = value2.substring(key.length() + 1, value2.length());
                        method = (MethodModel)methods.get(methodName);
                        if (method != null) {
                            propertyValue = (String)ruProperties.get(value2);
                            annotation = new AnnotationModel();
                            method.getMethodAnnotations().add(annotation);
                            annotation.setName(localeAnnotationName);
                            annotation.setValue(propertyValue);
                            method.setParameters(PropertiesUtils.getPropertyParameters((String)propertyValue));
                            continue;
                        }
                        System.err.println("Method does not exists in classmodel...\nclassname:" + classModel.getClassName() + "\n" + "packageName:" + classModel.getPackageName());
                    }
                    continue;
                }
                classModel = new ClassModel();
                classModel.setClassName(interfaceName);
                methods = new LinkedHashMap();
                classModel.setMethods(methods);
                packageName = key.substring(0, lastIndex);
                classModel.setPackageName(packageName);
                for (String value2 : propertyKeyValues) {
                    methodName = value2.substring(key.length() + 1, value2.length());
                    method = new MethodModel();
                    method.setMethodAnnotations(new ArrayList());
                    methods.put(methodName, method);
                    method.setMethodName(methodName);
                    propertyValue = (String)ruProperties.get(value2);
                    annotation = new AnnotationModel();
                    method.getMethodAnnotations().add(annotation);
                    annotation.setName(localeAnnotationName);
                    annotation.setValue(propertyValue);
                    method.setParameters(PropertiesUtils.getPropertyParameters((String)propertyValue));
                }
                cn = StringExtensions.firstCharacterToUpperCase((String)classModel.getClassName());
                classModel.setClassName((String)cn);
                interfaces.put(interfaceName, classModel);
                continue;
            }
            interfaceName = key;
            if (interfaces.containsKey(interfaceName)) {
                classModel = interfaces.get(interfaceName);
                packageName = interfaceName.toLowerCase();
                classModel.setPackageName(packageName);
                methods = classModel.getMethods();
                cn = propertyKeyValues.iterator();
                while (cn.hasNext()) {
                    methodName = value2 = cn.next();
                    method = (MethodModel)methods.get(methodName);
                    propertyValue = (String)ruProperties.get(value2);
                    annotation = new AnnotationModel();
                    method.getMethodAnnotations().add(annotation);
                    annotation.setName(localeAnnotationName);
                    annotation.setValue(propertyValue);
                    method.setParameters(PropertiesUtils.getPropertyParameters((String)propertyValue));
                }
                continue;
            }
            interfaceName = key;
            classModel = new ClassModel();
            packageName = interfaceName.toLowerCase();
            classModel.setPackageName(packageName);
            methods = new LinkedHashMap<String, MethodModel>();
            classModel.setMethods(methods);
            classModel.setClassName(interfaceName);
            cn = propertyKeyValues.iterator();
            while (cn.hasNext()) {
                methodName = value2 = cn.next();
                method = new MethodModel();
                method.setMethodAnnotations(new ArrayList());
                methods.put(methodName, method);
                method.setMethodName(methodName);
                propertyValue = (String)ruProperties.get(value2);
                annotation = new AnnotationModel();
                method.getMethodAnnotations().add(annotation);
                annotation.setName(localeAnnotationName);
                annotation.setValue(propertyValue);
                method.setParameters(PropertiesUtils.getPropertyParameters((String)propertyValue));
            }
            cn = StringExtensions.firstCharacterToUpperCase((String)classModel.getClassName());
            classModel.setClassName((String)cn);
            interfaces.put(interfaceName, classModel);
        }
    }

    private void init() {
        for (Map.Entry<String, Properties> entry : this.propertiesWithAnnotationNames.entrySet()) {
            String key = entry.getKey();
            Properties value = entry.getValue();
            Map matchedPrefixes = PropertiesUtils.getMatchedPrefixLists((Properties)value);
            this.getClassModels(matchedPrefixes, key, this.interfaces, value);
        }
    }
}

