/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.entitymapper;

import de.alpharogroup.db.domain.BusinessObject;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityBOMapper;
import de.alpharogroup.lang.TypeArgumentsUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dozer.DozerBeanMapper;
import org.dozer.Mapper;

public abstract class AbstractEntityBOMapper<E extends BaseEntity<?>, BO extends BusinessObject<?>>
implements EntityBOMapper<E, BO> {
    private final Mapper mapper;
    private final Class<E> entityClass = TypeArgumentsUtils.getTypeArgument(AbstractEntityBOMapper.class, this.getClass(), (int)0);
    private final Class<BO> businessObjectClass = TypeArgumentsUtils.getTypeArgument(AbstractEntityBOMapper.class, this.getClass(), (int)1);

    public AbstractEntityBOMapper() {
        this(Collections.emptyList());
    }

    public AbstractEntityBOMapper(List<String> mappingFiles) {
        this.mapper = this.newMapper(mappingFiles);
    }

    public Mapper newMapper(List<String> mappingFiles) {
        return new DozerBeanMapper(mappingFiles);
    }

    @Override
    public BO toBusinessObject(E entity) {
        return (BO)((BusinessObject)this.mapper.map(entity, this.getBusinessObjectClass()));
    }

    @Override
    public List<BO> toBusinessObjects(List<E> entities) {
        ArrayList<BO> businessObjects = new ArrayList<BO>();
        if (entities != null && !entities.isEmpty()) {
            for (BaseEntity entity : entities) {
                businessObjects.add(this.toBusinessObject(entity));
            }
        }
        return businessObjects;
    }

    @Override
    public List<E> toEntities(List<BO> businessObjects) {
        ArrayList<E> entities = new ArrayList<E>();
        if (businessObjects != null && !businessObjects.isEmpty()) {
            for (BusinessObject businessObject : businessObjects) {
                entities.add(this.toEntity(businessObject));
            }
        }
        return entities;
    }

    @Override
    public E toEntity(BO businessObject) {
        return (E)((BaseEntity)this.mapper.map(businessObject, this.getEntityClass()));
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public Class<BO> getBusinessObjectClass() {
        return this.businessObjectClass;
    }
}

