/*
 * Decompiled with CFR 0.152.
 */
package authorization.strategy.api;

import authorization.strategy.api.Right;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;

public abstract class Rights
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static MetaDataKey<HashSet<Right>> EDITABLE = new MetaDataKey<HashSet<Right>>(){
        private static final long serialVersionUID = 1L;
    };
    private static MetaDataKey<HashSet<Right>> RENDERABLE = new MetaDataKey<HashSet<Right>>(){
        private static final long serialVersionUID = 1L;
    };
    protected final Component component;

    protected Rights(Component component) {
        this.component = component;
    }

    private void add(MetaDataKey<HashSet<Right>> key, Right ... rights) {
        if (rights.length == 0) {
            this.component.setMetaData(key, null);
        } else {
            HashSet<Right> componentRights = (HashSet<Right>)this.component.getMetaData(key);
            if (componentRights == null) {
                componentRights = new HashSet<Right>();
                this.component.setMetaData(key, componentRights);
            }
            componentRights.clear();
            componentRights.addAll(Arrays.asList(rights));
        }
    }

    public Rights editable(Right ... rights) {
        this.add(EDITABLE, rights);
        return this;
    }

    public boolean isAuthorized(MetaDataKey<HashSet<Right>> key) {
        return this.onAuthorized(key);
    }

    public boolean isEditable() {
        return this.isAuthorized(EDITABLE);
    }

    public boolean isRenderable() {
        return this.isAuthorized(RENDERABLE);
    }

    protected abstract boolean onAuthorized(MetaDataKey<HashSet<Right>> var1);

    public Rights renderable(Right ... rights) {
        this.add(RENDERABLE, rights);
        return this;
    }
}

