/*
 * Decompiled with CFR 0.152.
 */
package authorization.strategy.api;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.request.component.IRequestableComponent;

public abstract class ComponentAuthorizationStrategy
implements IAuthorizationStrategy {
    public boolean isActionAuthorized(Component component, Action action) {
        if (action.equals((Object)Component.RENDER)) {
            return this.isRenderable(component);
        }
        if (action.equals((Object)Component.ENABLE)) {
            return this.isEditable(component);
        }
        return true;
    }

    protected abstract boolean isEditable(Component var1);

    public <T extends IRequestableComponent> boolean isInstantiationAuthorized(Class<T> componentClass) {
        if (!Page.class.isAssignableFrom(componentClass)) {
            return true;
        }
        return this.onInstantiationAuthorized(componentClass);
    }

    protected abstract boolean isRenderable(Component var1);

    protected abstract <T extends IRequestableComponent> boolean onInstantiationAuthorized(Class<T> var1);
}

