/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.auth.beans;

import java.util.Set;

public class AuthenticationResult<U, E> {
    private U user;
    private boolean valid;
    private Set<E> validationErrors;

    public static <U, E> AuthenticationResultBuilder<U, E> builder() {
        return new AuthenticationResultBuilder();
    }

    public AuthenticationResultBuilder<U, E> toBuilder() {
        return new AuthenticationResultBuilder().user(this.user).valid(this.valid).validationErrors(this.validationErrors);
    }

    public U getUser() {
        return this.user;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Set<E> getValidationErrors() {
        return this.validationErrors;
    }

    public void setUser(U user) {
        this.user = user;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setValidationErrors(Set<E> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticationResult)) {
            return false;
        }
        AuthenticationResult other = (AuthenticationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        U this$user = this.getUser();
        U other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        if (this.isValid() != other.isValid()) {
            return false;
        }
        Set<E> this$validationErrors = this.getValidationErrors();
        Set<E> other$validationErrors = other.getValidationErrors();
        return !(this$validationErrors == null ? other$validationErrors != null : !((Object)this$validationErrors).equals(other$validationErrors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthenticationResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        U $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        result = result * 59 + (this.isValid() ? 79 : 97);
        Set<E> $validationErrors = this.getValidationErrors();
        result = result * 59 + ($validationErrors == null ? 43 : ((Object)$validationErrors).hashCode());
        return result;
    }

    public String toString() {
        return "AuthenticationResult(user=" + this.getUser() + ", valid=" + this.isValid() + ", validationErrors=" + this.getValidationErrors() + ")";
    }

    public AuthenticationResult() {
    }

    public AuthenticationResult(U user, boolean valid, Set<E> validationErrors) {
        this.user = user;
        this.valid = valid;
        this.validationErrors = validationErrors;
    }

    public static class AuthenticationResultBuilder<U, E> {
        private U user;
        private boolean valid;
        private Set<E> validationErrors;

        AuthenticationResultBuilder() {
        }

        public AuthenticationResultBuilder<U, E> user(U user) {
            this.user = user;
            return this;
        }

        public AuthenticationResultBuilder<U, E> valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        public AuthenticationResultBuilder<U, E> validationErrors(Set<E> validationErrors) {
            this.validationErrors = validationErrors;
            return this;
        }

        public AuthenticationResult<U, E> build() {
            return new AuthenticationResult<U, E>(this.user, this.valid, this.validationErrors);
        }

        public String toString() {
            return "AuthenticationResult.AuthenticationResultBuilder(user=" + this.user + ", valid=" + this.valid + ", validationErrors=" + this.validationErrors + ")";
        }
    }
}

